% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFAR.r
\name{p_cfar}
\alias{p_cfar}
\title{Prediction of CFAR Processes}
\usage{
p_cfar(model, f, m = 3)
}
\arguments{
\item{model}{CFAR model.}

\item{f}{the functional time series data.}

\item{m}{the forecast horizon.}
}
\value{
The function returns a prediction of the CFAR process.
}
\description{
Prediction of CFAR processes.
}
\examples{
phi_func= function(x)
{
 	return(dnorm(x,mean=0,sd=0.1))
}
y=g_cfar1(100,5,phi_func)
f_grid=y$cfar
index=seq(1,1001,by=50)
f=f_grid[,index]
est=est_cfar(f,1)
pred=p_cfar(est,f,1)
}
\references{
Liu, X., Xiao, H., and Chen, R. (2016) Convolutional autoregressive models for functional time series. \emph{Journal of Econometrics}, 194, 263-282.
}
