% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nasdaq_data_link_pointintime.R
\name{NasdaqDataLink.pit.asofdate}
\alias{NasdaqDataLink.pit.asofdate}
\title{Retrieves Point In Time Data from the Nasdaq Data Link PIT endpoint.
As of date is used to see the table as it was at a specific point in time in the past.}
\usage{
NasdaqDataLink.pit.asofdate(datatable_code, start_date, paginate = FALSE, ...)
}
\arguments{
\item{datatable_code}{Datatable code on Nasdaq Data Link specified as a string.}

\item{start_date}{Lower date as a string.}

\item{paginate}{When set to TRUE, fetches up to 1,000,000 rows of data}

\item{...}{Additional named values that are interpreted as Nasdaq Data Link API parameters.}
}
\value{
Returns a data.frame.
}
\description{
Retrieves Point In Time Data from the Nasdaq Data Link PIT endpoint.
As of date is used to see the table as it was at a specific point in time in the past.
}
\details{
Set your \code{api_key} with \code{Nasdaq Data Link.api_key} function. For instructions on finding your api key go to \url{https://data.nasdaq.com/account/profile}
}
\examples{
\dontrun{
NasdaqDataLink.pit.asofdate('RSM/MSB', '2020-06-11', paginate=TRUE)
}
}
\seealso{
\code{\link{NasdaqDataLink.api_key}}
}
