% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nematode_energy_flux.R
\name{NEF}
\alias{NEF}
\alias{NEF.data.frame}
\alias{NEF.matrix}
\alias{NEF.default}
\title{Nematode Energy Footprints (NEF) Calculation}
\usage{
NEF(data, abundance, AE = list(Ba = 0.6, Fu = 0.38, Pp = 0.25, Op = 0.5), ...)

\method{NEF}{data.frame}(data, abundance, AE = list(Ba = 0.6, Fu = 0.38, Pp = 0.25, Op = 0.5), ...)

\method{NEF}{matrix}(data, abundance, AE = list(Ba = 0.6, Fu = 0.38, Pp = 0.25, Op = 0.5), ...)

\method{NEF}{default}(data, abundance, AE = list(Ba = 0.6, Fu = 0.38, Pp = 0.25, Op = 0.5), ...)
}
\arguments{
\item{data}{A data.frame or matrix containing nematode genus abundance data. Rows represent samples, and columns represent genera.}

\item{abundance}{A data.frame containing abundance information for the samples. It must match the row names of the input data.}

\item{AE}{A named list specifying the assimilation efficiencies for nematode feeding groups.
Must contain the following elements:
\itemize{
\item Ba - Assimilation efficiency for bacterial feeders (default: 0.6)
\item Fu - Assimilation efficiency for fungal feeders (default: 0.38)
\item Pp - Assimilation efficiency for plant feeders (default: 0.25)
\item Op - Assimilation efficiency for omnivores/predators (default: 0.5)
}}

\item{...}{Additional arguments (currently unused).}
}
\value{
A list object of class \code{"NEF"} containing the following components:
\describe{
\item{data}{A list with original input data:
\itemize{
\item data - Original genus abundance data.frame or matrix of nematode genera
\item Abundance - Total abundance data used for calculations
}
}
\item{Energy.flux}{A list containing energy flow calculations:
\itemize{
\item Energy.flux: Data frame of energy flows (\eqn{\mu g~C~100g^{-1}~dry~soil}) per feeding group. Columns:
\itemize{
\item Sample.ID - Sample identifier
\item BaEF - Bacterial feeders energy flows
\item FuEF - Fungal feeders energy flows
\item PpEF - Plant feeders energy flows
\item OpEF - Omnivores/Predators energy flows
\item TNEF - Total energy flows of nematodes
}
\item C.flux.node: Data frame of Biomass (\eqn{\mu g~C~100g^{-1}~dry~soil}) per feeding group. Columns:
\itemize{
\item Sample.ID - Sample identifier
\item Ba - Bacterial feeders biomass
\item Fu - Fungal feeders biomass
\item Pp - Plant feeders biomass
\item Op - Omnivores/Predators biomass
}
\item C.flux.path: Data frame of energy flows (\eqn{\mu g~C~100g^{-1}~dry~soil~day^{-1}}). Columns:
\itemize{
\item Sample.ID - Sample identifier
\item R.to.Ba - Carbon flux from Resources to bacterial feeders
\item R.to.Fu - Carbon flux from Resources to fungal feeders
\item R.to.Pp - Carbon flux from Resources to plant feeders
\item Ba.to.Op - Carbon flux from bacterial to omnivorous channels
\item Fu.to.Op - Carbon flux from fungal to omnivorous channels
\item Pp.to.Op - Carbon flux from plant to omnivorous channels
}
\item U: Data frame of ecosystem stability indices. Columns:
\itemize{
\item Sample.ID - Sample identifier
\item U - Energy flow uniformity index
}
}
}
}
}
\description{
Nematode Energy Footprints (NEF) Calculation
}
\examples{
data <- data.frame(
  Cephalobus = c(10, 20, 30),
  Eucephalobus = c(5, 10, 12),
  Acrobeloides = c(1, 2, 3),
  Caenorhabditis = c(5, 8, 15),
  Aphelenchus = c(5, 13, 11),
  Leptonchus = c(3, 10, 15),
  Pratylenchus = c(9, 2, 15),
  Tylenchus = c(5, 0, 15),
  Mesodorylaimus = c(7, 10, 18),
  Discolaimus = c(1, 10, 25),
  row.names = c("Sample1", "Sample2", "Sample3")
)
abundance <- data.frame(
  Abundance = c(100, 200, 300),
  row.names = c("Sample1", "Sample2", "Sample3")
)
result <- NEF(data, abundance)
print(result)
}
