% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_nematode_genus.R
\name{check_nematode_genus}
\alias{check_nematode_genus}
\alias{check_nematode_genus.character}
\alias{check_nematode_genus.data.frame}
\alias{check_nematode_genus.default}
\title{Check validity of nematode genus names against reference database}
\usage{
check_nematode_genus(Query.genus, Query.col = NULL, show.details = TRUE, ...)

\method{check_nematode_genus}{character}(Query.genus, Query.col = NULL, show.details = TRUE, ...)

\method{check_nematode_genus}{data.frame}(Query.genus, Query.col, show.details = TRUE, ...)

\method{check_nematode_genus}{default}(Query.genus, Query.col = NULL, show.details = TRUE, ...)
}
\arguments{
\item{Query.genus}{Input to check: can be \code{character vector} or \code{data.frame}}

\item{Query.col}{When input is \code{data.frame}, specifies column name containing genus names
(ignored for character input)}

\item{show.details}{Logical controlling output format:
\itemize{
\item \code{TRUE}: returns data.frame with query, existence status, and full reference info
\item \code{FALSE}: returns only invalid/missing genus names
}}

\item{...}{Additional arguments (currently unused).}
}
\value{
Output varies by input type and show.details:
\itemize{
\item For \code{character vector} input:
\itemize{
\item show.details = TRUE: data.frame with query, existence, and reference data
\item show.details = FALSE: character vector of invalid genera
}
\item For \code{data.frame} input: same as character input for the specified column
\item For unsupported types: error message
}
}
\description{
This generic function validates nematode genus names by checking
their existence in a reference database (nematode.info). It
supports multiple input types and provides flexible
output formats.
}
\examples{
# Check character vector
check_nematode_genus(c("Caenorhabditis", "Wrong"))

# Check data.frame column
df <- data.frame(genus = c("Meloidogyne", "XXX"))
check_nematode_genus(Query.genus = df, Query.col = "genus")

}
