% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecological_indices.R
\name{rel_abundance}
\alias{rel_abundance}
\alias{rel_abundance.data.frame}
\alias{rel_abundance.matrix}
\alias{rel_abundance.default}
\title{Calculate the Relative Abundance of Nematodes}
\usage{
rel_abundance(data, ...)

\method{rel_abundance}{data.frame}(data, ...)

\method{rel_abundance}{matrix}(data, ...)

\method{rel_abundance}{default}(data, ...)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix}. The nematode abundance table where rows represent samples and columns represent nematodes.
Each element indicates the count of a specific nematode in the corresponding sample.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A \code{data.frame} or \code{matrix} (matching the input type) containing the relative abundance of each nematode in each sample.
}
\description{
This function calculates the relative abundance of nematodes for each sample.
The relative abundance is defined as the proportion of each nematode's count to the total count of all nematodes in a sample.
}
\examples{
# Example with a data frame
df <- data.frame(
  Species1 = c(10, NA, 15),
  Species2 = c(5, 10, NA),
  Species3 = c(8, 12, 10),
  row.names = c("A", "B", "C")
)
rel_abundance(df)

# Example with a matrix
mat <- matrix(c(10, NA, 15, 5, 10, NA, 8, 12, 10), nrow = 3, byrow = TRUE)
colnames(mat) <- c("Species1", "Species2", "Species3")
row.names(mat) <- c("A", "B", "C")
rel_abundance(mat)

}
