% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\docType{methods}
\name{inCone}
\alias{inCone}
\alias{inCone,agentMatrix,numeric,numeric,matrix-method}
\title{Agents in cone}
\usage{
inCone(turtles, radius, angle, agents, world, torus = FALSE)

\S4method{inCone}{agentMatrix,numeric,numeric,matrix}(turtles, radius, angle,
  agents, world, torus = FALSE)
}
\arguments{
\item{turtles}{AgentMatrix object representing the moving agents.}

\item{radius}{Numeric. Vector of distances from \code{turtles} to locate
\code{agents}. Must be of length 1 or of length \code{turtles}.}

\item{angle}{Numeric. Vector of angles to define the size of the cone of vision
for the \code{turtles}. The cone of vision is defined between the
direction of their headings minus \code{angle / 2}
to the direction of their headings plus \code{angle / 2}. Must be of
length 1 or
of length \code{turtles}.}

\item{agents}{Matrix (ncol = 2) with the first column "pxcor" and the second
              column "pycor" representing the patches coordinates, or

              AgentMatrix object representing the moving agents.}

\item{world}{WorldMatrix or worldArray object.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}
}
\value{
Matrix (ncol = 3) with the first column "pxcor"
        and the second column "pycor" representing the coordinates of the
        patches among \code{agents2} within the cone of vision of each of the
        \code{turtles}
        which are reprensented by the "id" column, if
        \code{agents} are patches, or

        Matrix (ncol = 2) with the first column "who"
        representing the "who" numbers of the
        turtles among \code{agents2} within the cone of vision of each of  the
        \code{turtles}
        which are reprensented by the "id" column, if
        \code{agents} are turtles.
}
\description{
Report the \code{agents} within the "cone of vision" in front of each one of the
\code{turtles}.
}
\details{
\code{agents} are reported if there are within \code{radius}
         distance of the turtle and their direction from the turtle is within
         \code{[-angle, + angle]} of the turtle's heading.

         Distances to patches are calculated to their center.

         If \code{torus = FALSE}, \code{world} does not need to be provided.

         If \code{torus = TRUE}, the \code{radius} distances are calculated
         around the sides of the \code{world} to select \code{agents}.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))

p1 <- inCone(turtles = t1, radius = 2, agents = patches(w1), angle = 90)
t2 <- inCone(turtles = turtle(t1, who = 0), radius = 2, angle = 90, agents = t1)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#in-cone}
}
\author{
Sarah Bauduin
}
