% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldNLR-classes-methods.R
\docType{methods}
\name{PxcorPycorFromCell}
\alias{PxcorPycorFromCell}
\alias{PxcorPycorFromCell,worldNLR,numeric-method}
\title{Patches coordinates from cells numbers}
\usage{
PxcorPycorFromCell(world, cellNum)

\S4method{PxcorPycorFromCell}{worldNLR,numeric}(world, cellNum)
}
\arguments{
\item{world}{WorldMatrix or worldArray object.}

\item{cellNum}{Integer. Vector of cells number.}
}
\value{
Matrix (ncol = 2) with the first column "pxcor" and the second
        column "pycor" in the order of the given \code{cellNum}.
}
\description{
Report the patches coordinates \code{pxcor} and \code{pycor} given the cells
numbers as defined for a Raster* object.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
cellNum <- cellFromPxcorPycor(world = w1, pxcor = 0, pycor = 9)
PxcorPycorFromCell(world = w1, cellNum = cellNum)
cellNum <- cellFromPxcorPycor(world = w1, pxcor = c(0, 1, 2), pycor = 0)
PxcorPycorFromCell(world = w1, cellNum = cellNum)


}
\author{
Sarah Bauduin
}
