% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patch-functions.R
\docType{methods}
\name{pExist}
\alias{pExist}
\alias{pExist,worldNLR,numeric,numeric-method}
\title{Do the patches exist?}
\usage{
pExist(world, pxcor, pycor)

\S4method{pExist}{worldNLR,numeric,numeric}(world, pxcor, pycor)
}
\arguments{
\item{world}{WorldMatrix or worldArray object.}

\item{pxcor}{Integer. Vector of patches pxcor coordinates. Must be of length 1
or of the same length as \code{pycor}.}

\item{pycor}{Integer. Vector of patches pycor coordinates. Must be of length 1
or of the same length as \code{pxcor}.}
}
\value{
Logical.
}
\description{
Report \code{TRUE} if a patch exists inside the \code{world}'s extent, report
\code{FALSE} otherwise.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
pExist(world = w1, pxcor = -1, pycor = 2)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#member}
}
\author{
Sarah Bauduin
}
