% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patch-functions.R
\docType{methods}
\name{patch}
\alias{patch}
\alias{patch,worldNLR,numeric,numeric-method}
\title{Patches coordinates}
\usage{
patch(world, x, y, duplicate = FALSE, torus = FALSE, out = FALSE)

\S4method{patch}{worldNLR,numeric,numeric}(world, x, y,
  duplicate = FALSE, torus = FALSE, out = FALSE)
}
\arguments{
\item{world}{WorldMatrix or worldArray object.}

\item{x}{Numeric. Vector of x coordinates. Must be of same
length as \code{y}.}

\item{y}{Numeric. Vector of y coordinates. Must be of same
length as \code{x}.}

\item{duplicate}{Logical. If more than one location \code{[x, y]}
fall into the same patch and \code{duplicate == TRUE}, the
patch coordinates are returned the number of times the locations.
If \code{duplicate == FALSE}, the patch coordinates
are only returned once.
Default is \code{duplicate == FALSE}.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}

\item{out}{Logical. If \code{out = FALSE}, no patch coordinates are returned
for patches outside of the \code{world}'s extent, if \code{out = TRUE},
\code{NA} are returned.
Default is \code{out = FALSE}.}
}
\value{
Matrix (ncol = 2) with the first column "pxcor" and the second column
        "pycor" representing the patches coordinates at \code{[x, y]}.
}
\description{
Report the coordinates of the patches at the given \code{[x, y]} locations.
}
\details{
If a location \code{[x, y]} is outside the \code{world}'s extent and
         \code{torus = FALSE} and \code{out = FALSE}, no patch coordinates are returned;
         if \code{torus = FALSE} and \code{out = TRUE}, \code{NA} are returned;
         if \code{torus = TRUE}, the patch coordinates from a wrapped \code{world} are
         returned.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
patch(world = w1, x = c(0, 9.1, 8.9, 5, 5.3), y = c(0, 0, -0.1, 12.4, 12.4))
patch(world = w1, x = c(0, 9.1, 8.9, 5, 5.3), y = c(0, 0, -0.1, 12.4, 12.4),
      duplicate = TRUE)
patch(world = w1, x = c(0, 9.1, 8.9, 5, 5.3), y = c(0, 0, -0.1, 12.4, 12.4),
      torus = TRUE)
patch(world = w1, x = c(0, 9.1, 8.9, 5, 5.3), y = c(0, 0, -0.1, 12.4, 12.4),
      torus = TRUE, duplicate = TRUE)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#patch}
}
\author{
Sarah Bauduin
}
