% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{IntermediateProperties}
\alias{IntermediateProperties}
\title{Calculate the intermediate network properties in the discovery dataset}
\usage{
IntermediateProperties(dData, dCorr, dNet, tNodeNames, moduleAssignments,
  modules)
}
\arguments{
\item{dData}{scaled data matrix from the \emph{discovery} dataset.}

\item{dCorr}{matrix of correlation coefficients between all pairs of 
variables/nodes in the \emph{discovery} dataset.}

\item{dNet}{adjacency matrix of network edge weights between all pairs of 
nodes in the \emph{discovery} dataset.}

\item{tNodeNames}{a character vector of node names in the test dataset}

\item{moduleAssignments}{a named character vector containing the module 
each node belongs to in the discovery dataset.}

\item{modules}{a character vector of modules for which to calculate the 
module preservation statistics.}
}
\value{
a list containing three lists: a list of weighted degree vectors,
  a list of correlation coefficient vectors, and a list of node 
  contribution vectors. There is one vector for each module in each list.
}
\description{
These properties are need at every permutation: so they will be computed 
once.
}
\details{
\subsection{Input expectations:}{
  Note that this function expects all inputs to be sensible, as checked by
  the R function 'checkUserInput' and processed by 'modulePreservation'. 
  
  These requirements are:
  \itemize{
  \item{The ordering of node names across 'dData', 'dCorr', and 'dNet' is
        consistent.}
  \item{The columns of 'dData' are the nodes.}
  \item{'dData' has been scaled by 'Scale'.}
  \item{'dCorr' and 'dNet'  are square matrices, and their rownames are 
        identical to their column names.}
  \item{'moduleAssigments' is a named character vector, where the names
        represent node labels found in the discovery dataset (e.g. 'dNet').}
  }
}
}

