% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCC_Significance.R
\name{LCC_Significance}
\alias{LCC_Significance}
\title{LCC_Significance}
\usage{
LCC_Significance(
  N = N,
  Targets = Targets,
  G,
  bins = 100,
  hypothesis = "greater",
  min_per_bin = 20
)
}
\arguments{
\item{N}{Number of randomizations.}

\item{Targets}{Name of the nodes that the subgraph will focus on - Those are the nodes you want to know whether if forms an LCC.}

\item{G}{The  graph of interest (often, in NetMed it is an interactome - PPI).}

\item{bins}{the number os bins for the degree preserving randomization.}

\item{hypothesis}{are you expecting an LCC greater or smaller than the average?}

\item{min_per_bin}{the minimum size of each bin.}
}
\value{
a list with the LCC
- $LCCZ all values from the randomizations
- $mean the average LCC of the randomizations
- $sd the sd LCC of the randomizations
- $Z The score
- $LCC the LCC of the given targets
- $emp\_p the empirical p-value for the LCC
}
\description{
Calculates the Largest Connected Component (LCC) from a given graph, and calculates its significance using a degree preserving approach.
Menche, J., et al (2015) <doi.org:10.1126/science.1065103>
}
\examples{
set.seed(666)
net  = data.frame(
Node.1 = sample(LETTERS[1:15], 15, replace = TRUE),
Node.2 = sample(LETTERS[1:10], 15, replace = TRUE))
net$value = 1
net =  CoDiNA::OrderNames(net)
net = unique(net)

g <- igraph::graph_from_data_frame(net, directed = FALSE )
plot(g)
targets = c("I", "H", "F", "E")
LCC_Significance(N = 100,
                 Targets = targets,
                                  G = g,
                                  bins = 5,
                                  min_per_bin = 2)
                                  # in a real interactome, please use the default

}
