% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cascade.R
\name{as.cascade}
\alias{as.cascade}
\title{Create a cascade object from input data}
\usage{
as.cascade(data, ...)
}
\arguments{
\item{data}{cascades to be converted. See Details for supported classes.}

\item{...}{additional arguments passed to dispatched method. See methods 
linked in Details for more information.}
}
\value{
An object of class \code{cascade}. This is a list containing three
    (named) elements: 
    \enumerate{
        \item \code{"node_names"} A character vector of node names.
        \item \code{"cascade_nodes"} A list with one character vector per
            cascade containing the node names in order of the events.
        \item \code{"cascade_times"} A list with one element per cascade 
            containing the event times for the nodes in \code{"cascade_names"}.
    }
}
\description{
A generic function to transform input data into a cascade object to be used 
in other \code{NetworkInference} functions. The method invoked depends on the 
class of the first argument. See section Details for available methods.
}
\examples{

\dontrun{
# For data frames 
df <- simulate_rnd_cascades(10, n_nodes = 20)
cascades <- as.cascade(df)
is.cascade(cascades)

# For matrices
cascade_matrix <- as.matrix(cascades)
cascades <- as.cascade(cascade_matrix)
is.cascade(cascades)
}
}
