% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netinf.R
\name{netinf}
\alias{netinf}
\title{Infer latent diffusion network}
\usage{
netinf(cascades, trans_mod = "exponential", n_edges, lambda)
}
\arguments{
\item{cascades}{an object of class cascade containing node and cascade 
information. See \code{\link{as.cascade}} for details.}

\item{trans_mod}{character, indicating the choice of model: 
\code{"exponential"} or \code{"rayleigh"}.}

\item{n_edges}{numeric, number of edges to infer.}

\item{lambda}{numeric, alpha for transmission model.}
}
\value{
Returns the inferred diffusion network as an edgelist in an object of 
    class \code{diffnet} and \code{\link[base]{data.frame}}. The first 
    column contains the sender, the second column the receiver node. The 
    third column contains the improvement in fit from adding the edge that is
    represented by the row.
}
\description{
Infer a network of diffusion ties from a set of cascades. Each cascade 
is defined by pairs of node ids and infection times.
}
\details{
The algorithm is describe in detail in Gomez-Rodriguez et al. (2010). 
Additional information can be found on the 
netinf website (\url{http://snap.stanford.edu/netinf/}).

If higher performance is required and for very large data sets, a faster pure C++ 
implementation is available in the Stanford Network Analysis Project (SNAP). 
The software can be downloaded at \url{http://snap.stanford.edu/netinf/}.
}
\examples{

# Data already in cascades format:
data(cascades)
out <- netinf(cascades, trans_mod = "exponential", n_edges = 5, lambda = 1)

# Starting with a dataframe
df <- simulate_rnd_cascades(10, n_nodes = 20)
cascades2 <- as_cascade_long(df, node_names = unique(df$node_name))
out <- netinf(cascades2, trans_mod = "exponential", n_edges = 5, lambda = 1)

}
\references{
M. Gomez-Rodriguez, J. Leskovec, A. Krause. Inferring Networks of Diffusion 
and Influence.The 16th ACM SIGKDD Conference on Knowledge Discovery and 
Data Mining (KDD), 2010.
}
