% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.cascade}
\alias{plot.cascade}
\title{Plot a cascade object}
\usage{
\method{plot}{cascade}(x, label_nodes = TRUE, selection = NULL, ...)
}
\arguments{
\item{x}{object of class cascade to be plotted.}

\item{label_nodes}{logical, indicating if should the nodes in each cascade be 
labeled. If the cascades are very dense setting this to \code{FALSE} is
recommended.}

\item{selection}{a vector of cascade ids to plot.}

\item{...}{additional arguments passed to plot.}
}
\value{
A ggplot plot object.
}
\description{
Allows plotting of one or multiple, labeled or unlabeled cascades.
}
\details{
The function returns a ggplot plot object (class \code{gg, ggplot}) which 
can be modified like any other ggplot. See the ggplot documentation and the 
examples below for more details.
}
\examples{

data(cascades)
plot(cascades, selection = names(cascades$cascade_nodes)[1:5])
plot(cascades, label_nodes = FALSE, selection = sample(1:54, 20))

# Modify resulting ggplot object
library(ggplot2) 
p <- plot(cascades, label_nodes = FALSE, selection = sample(1:54, 20))
## Add a title
p <- p + ggtitle('Your Title')
p
## Change Axis
p <- p + xlab("Your modified y axis label") #x and y labels are flipped here
p <- p + ylab("Your modified x axis label") #x and y labels are flipped here
p

}
