% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{LoGo}
\alias{LoGo}
\title{Local/Global Sparse Inverse Covariance Matrix}
\usage{
LoGo(data, normal = FALSE, na.data = c("pairwise", "listwise", "fiml"))
}
\arguments{
\item{data}{Must be a dataset}

\item{normal}{Should data be transform to a normal distribution?
Defaults to FALSE. Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal
(computes correlations using the \emph{cor_auto} fucntion from the \emph{qgraph} package)}

\item{na.data}{How should missing data be handled?
For "pairwise" deletion \emph{na.rm} is applied.
For "listwise" deletion the \emph{na.omit} fucntion is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\emph{psych} package).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}
}
\value{
Returns a sparse TMFG-filtered inverse covariance matrix
(can be converted to a zero-order partial correlation matrix using the \emph{-cov2cor} function; see examples)
}
\description{
Applies the Local/Global method to estimate the sparse inverse covariance matrix using a TMFG-filtered network
(see and cite Barfuss et al., 2016)
}
\examples{
LoGonet<-LoGo(hex)

corrLoGonet<-(-cov2cor(LoGonet))
diag(corrLoGonet)<-0
}
\references{
Barfuss, W., Massara, G. P., Di Matteo, T., & Aste, T. (2016).
Parsimonious modeling with information filtering networks.
\emph{Physical Review E}, \emph{94}(6), 062306.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
