% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{cpmFP}
\alias{cpmFP}
\title{Connectome-based Predictive Modeling--Fingerprinting}
\usage{
cpmFP(session1, session2, progBar = TRUE)
}
\arguments{
\item{session1}{Array from \code{\link{convertConnBrainMat}} function
(first session)}

\item{session2}{Array from \code{\link{convertConnBrainMat}} function
(second session)}

\item{progBar}{Should progress bar be displayed?
Defaults to TRUE.
Set to FALSE for no progress bar}
}
\value{
Returns a matrix containing the percentage and number of correctly identified subjects for sessions 1 and 2
}
\description{
Applies the Connectome-based Predictive Modeling approach to neural data.
This method identifies individuals based on their specific connectivity patterns.
\strong{Please cite Finn et al., 2015; Rosenberg et al., 2016; Shen et al., 2017}
}
\references{
Finn, E. S., Shen, X., Scheinost, D., Rosenberg, M. D., Huang, J., Chun, M. M., Papademetris, X., Constable, R. T. (2015).
Functional connectome fingerprinting: Identifying individuals using patterns of brain connectivity.
\emph{Nature Neuroscience}, \emph{18}(11), 1664-1671.

Rosenberg, M. D., Finn, E. S., Scheinost, D., Papademetris, X., Shen, X., Constable, R. T., Chun, M. M. (2016).
A neuromarker of sustained attention from whole-brain functional connectivity.
\emph{Nature Neuroscience}, \emph{19}(1), 165-171.

Shen, X. Finn, E. S., Scheinost, D., Rosenberg, M. D., Chun, M. M., Papademetris, X., Constable, R. T. (2017).
Using connectome-based predictive modeling to predict individual behavior from brain connectivity.
\emph{Nature Protocols}, \emph{12}(3), 506-518.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
