% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{gateway}
\alias{gateway}
\title{Gateway Coefficient}
\usage{
gateway(A, factors = c("walktrap", "louvain"), cent = c("strength",
  "betweenness"))
}
\arguments{
\item{A}{Network adjacency matrix}

\item{factors}{A vector of corresponding to each item's factor.
Defaults to "walktrap" for the walktrap community detection algorithm.
Set to "louvain" for the louvain community detection algorithm.
Can also be set to user-specified factors (see examples)}

\item{cent}{Centrality to community gateway coefficient.
Defaults to "strength".
Set to "betweenness" to use the betweenness centrality}
}
\value{
Returns a list of overall (signs not considered; overall),
negative (negative), and positive (positive) gateway coefficients
}
\description{
Computes the gateway coefficient for each node. The gateway
coefficient measures a node's connections between its community and other communities.
Nodes that are solely responsible for inter-community connectivity will
have higher gateway coefficient values. Positive and negative signed weights
for gateway coefficients are computed separately.
}
\examples{
#theoretical factors
factors <- c(rep(1,8), rep(2,8), rep(3,8), rep(4,8), rep(5,8), rep(6,8))

A <- TMFG(neoOpen)$A

gw <- gateway(A, factors = factors)

#walktrap factors
wgw <- gateway(A, factors = "walktrap")
}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}(3), 1059-1069.

Vargas, E. R., & Wahl, L. M. (2014).
The gateway coefficient: A novel metric for identifying critical connections in modular networks.
\emph{The European Physical Journal B}, \emph{87}(161), 1-10.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
