% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depend.R
\name{depend}
\alias{depend}
\title{Dependency Network Approach}
\usage{
depend(data, normal = FALSE, na.data = c("pairwise", "listwise",
  "fiml", "none"), index = FALSE, fisher = FALSE, progBar = TRUE)
}
\arguments{
\item{data}{A set of data}

\item{normal}{Should data be transformed to a normal distribution?
Defaults to FALSE. Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal
(computes correlations using the \link[qgraph]{cor_auto} function)}

\item{na.data}{How should missing data be handled?
For "listwise" deletion the \code{\link{na.omit}} function is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\link[psych]{corFiml}).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{index}{Should correlation with the latent variable
(i.e., weighted average of all variables) be removed?
Defaults to FALSE.
Set to TRUE to remove common latent factor}

\item{fisher}{Should Fisher's Z-test be used to keep significantly higher influences (index only)?
Defaults to FALSE.
Set to TRUE to remove non-significant influences}

\item{progBar}{Should progress bar be displayed?
Defaults to TRUE.
Set to FALSE for no progress bar}
}
\value{
Returns an adjacency matrix of dependencies
}
\description{
Generates a dependency matrix of the data (index argument is still in testing phase)
}
\examples{
D <- depend(neoOpen)

Dindex <- depend(neoOpen, index = TRUE)

}
\references{
Kenett, D. Y., Tumminello, M., Madi, A., Gur-Gershgoren, G., Mantegna, R. N., & Ben-Jacob, E. (2010).
Dominating clasp of the financial sector revealed by partial correlation analysis of the stock market.
\emph{PloS one}, \emph{5}, e15032.
doi: \href{https://doi.org/10.1371/journal.pone.0015032}{10.1371/journal.pone.0015032}

Kenett, D. Y., Huang, X., Vodenska, I., Havlin, S., & Stanley, H. E. (2015).
Partial correlation analysis: Applications for financial markets.
\emph{Quantitative Finance}, \emph{15}, 569-578.
doi: \href{https://doi.org/10.1080/14697688.2014.946660}{10.1080/14697688.2014.946660}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
