% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gateway.R
\name{gateway}
\alias{gateway}
\title{Gateway Coefficient}
\usage{
gateway(A, comm = c("walktrap", "louvain"), cent = c("strength",
  "betweenness"))
}
\arguments{
\item{A}{Network adjacency matrix}

\item{comm}{A vector of corresponding to each item's community.
Defaults to \code{"walktrap"} for the \code{\link[igraph]{cluster_walktrap}} community detection algorithm.
Set to \code{"louvain"} for the \code{\link[NetworkToolbox]{louvain}} community detection algorithm.
Can also be set to user-specified communities (see examples)}

\item{cent}{Centrality to community gateway coefficient.
Defaults to \code{"strength"}.
Set to \code{"betweenness"} to use the \code{\link[NetworkToolbox]{betweenness}} centrality}
}
\value{
Returns a list containing:

\item{overall}{Gateway coefficient without signs considered}

\item{positive}{Gateway coefficient with only positive sign}

\item{negative}{Gateway coefficient wih only negative sign}
}
\description{
Computes the gateway coefficient for each node. The gateway
coefficient measures a node's connections between its community and other communities.
Nodes that are solely responsible for inter-community connectivity will
have higher gateway coefficient values. Positive and negative signed weights
for gateway coefficients are computed separately.
}
\examples{
#theoretical communities
comm <- rep(1:8, each = 6)

# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

gw <- gateway(A, comm = comm)

#walktrap communities
wgw <- gateway(A, comm = "walktrap")

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}, 1059-1069.
doi: \href{https://doi.org/10.1016/j.neuroimage.2009.10.003}{10.1016/j.neuroimage.2009.10.003}

Vargas, E. R., & Wahl, L. M. (2014).
The gateway coefficient: A novel metric for identifying critical connections in modular networks.
\emph{The European Physical Journal B}, \emph{87}, 1-10.
doi: \href{https://doi.org/10.1140/epjb/e2014-40800-7}{10.1140/epjb/e2014-40800-7}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
