% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diag4Darray.R
\name{diag4Darray}
\alias{diag4Darray}
\title{Define function to create a 'diagonal' array or get the diagonal of an array}
\usage{
diag4Darray(x = 1, dim = length(x))
}
\arguments{
\item{x}{\code{number} or \code{vector} defining the value of the diagonal of \code{4D array}}

\item{dim}{\code{integer} defining the length of the diagonal. Default is \code{length(x)}.
If \code{length(x) != 1}, \code{dim} must be equal to \code{length(x)}.}
}
\value{
\code{array} with all elements zero except the diagonal, with dimensions c(dim,dim,dim)
}
\description{
Define function to create a 'diagonal' array or get the diagonal of an array
}
\details{
The diagonal of a 4D array has been defined as those elements in positions c(int,int,int,int),
i.e., the four digits are the same.
}
\examples{
x <- diag4Darray(c(1,3,6,2), dim = 4)
x
# , , 1, 1
#
#      [,1] [,2] [,3] [,4]
# [1,]    1    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    0
#
# , , 2, 1
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    0
#
# , , 3, 1
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    0
#
# , , 4, 1
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    0
#
# , , 1, 2
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    0
#
# , , 2, 2
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    3    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    0
#
# , , 3, 2
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    0
#
# , , 4, 2
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    0
#
# , , 1, 3
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    0
#
# , , 2, 3
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    0
#
# , , 3, 3
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    6    0
# [4,]    0    0    0    0
#
# , , 4, 3
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    0
#
# , , 1, 4
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    0
#
# , , 2, 4
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    0
#
# , , 3, 4
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    0
#
# , , 4, 4
#
#      [,1] [,2] [,3] [,4]
# [1,]    0    0    0    0
# [2,]    0    0    0    0
# [3,]    0    0    0    0
# [4,]    0    0    0    2
diag4Darray(x)
# 1, 3, 6, 2
}
