% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_and_save_decoding_results.R
\name{log_save_results}
\alias{log_save_results}
\title{Saves the DECODING_RESULTS and logs the parameters used in the analysis}
\usage{
log_save_results(
  DECODING_RESULTS,
  save_directory_name,
  result_name = "No result name set"
)
}
\arguments{
\item{DECODING_RESULTS}{A list of results returned by the cross-validator's
run_decoding method.}

\item{save_directory_name}{A string specifying the directory name where the
decoding results should be saved.}

\item{result_name}{A string that gives a human readable name for the results
that are to be saved. This name can be used to load the results later. The
default value is "No result name set".}
}
\value{
Does not return a value but instead creates a directory that stores
an .rda file with the decoding results and either creates or updates a
manifest files that has information about the decoding results.
}
\description{
This function takes results returned by the cross-validator's \code{run_decoding()}
method and uses the cross-validator's \code{get_properties()} method to save a log
of the results that be used to reload the results.
}
