% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_standard.R
\name{run_decoding.cv_standard}
\alias{run_decoding.cv_standard}
\title{A cross-validator (CV) method to run a decoding analysis}
\usage{
\method{run_decoding}{cv_standard}(cv_obj)
}
\arguments{
\item{cv_obj}{A CV object. Parameters that affect the decoding analyses are
set in the CV's constructor.}
}
\value{
A list, usually called \code{DECODING_RESULTS}, that contains the results
from the decoding analysis. This \code{DECODING_RESULTS} list should contain the
result compiled by the result metric objects, as well as a list in
\code{DECODING_RESULTS$cross_validation_paramaters$parameter_df} contains data
on all that DS, FP, CL and RM parameters that were used in the decoding
analysis that can be used to store and retrieve the results. Additionally,
the DS, FP, CL and RM objects used in the analysis can be saved in the
\code{DECODING_RESULTS$cross_validation_paramaters}.
}
\description{
This method runs a full decoding analysis based on the DS, FP, CL, and RM
objects that are passed to the cross-validator constructor.
}
\seealso{
\code{\link[=cv_standard]{cv_standard()}}
}
