% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonProbEst.R
\name{confidence_interval}
\alias{confidence_interval}
\title{Confidence interval}
\usage{
confidence_interval(estimation, std_dev, confidence = 0.95)
}
\arguments{
\item{estimation}{A numeric value specifying the point estimation.}

\item{std_dev}{A numeric value specifying the standard deviation of the point estimation.}

\item{confidence}{A numeric value between 0 and 1 specifying the confidence level, taken as 1 - alpha (1 - Type I error). By default, its value is 0.95.}
}
\value{
A vector containing the lower and upper bounds.
}
\description{
Calculates the confidence interval for the estimator considered.
}
\examples{
covariates = c("education_primaria","education_secundaria",
"education_terciaria", "age", "sex")
pi = propensities(sampleNP, sampleP, covariates, algorithm = "glm", smooth = FALSE)
psa_weights = sc_weights(pi$convenience)
N = 50000
Y_est = total_estimation(sampleNP, psa_weights, estimated_vars = "vote_pens", N = N)
VY_est = fast_jackknife_variance(sampleNP, psa_weights,
   estimated_vars = "vote_pens") * N^2
confidence_interval(Y_est, sqrt(VY_est), confidence = 0.90)
}
