% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Enders_Siklos_2001.R
\name{Enders_Siklos_2001}
\alias{Enders_Siklos_2001}
\title{Enders and Siklos(2001) Nonlinear Cointegration Test Function}
\usage{
Enders_Siklos_2001(y, x, case = 2, max_lags)
}
\arguments{
\item{y}{series name}

\item{x}{series name,}

\item{case}{if no lag 1, if one lag 2, if four lag 3, default case=2}

\item{max_lags}{maximum lag (Apropriate lag is selected by Akaike Information Criteria)}
}
\value{
"Model" Estimated model

"Selected Lag" the lag order

"p1=p2=0 Statistic" the value of the test statistic

"p1=p2 Statistic" the value of the test statistic

"p value" the probability of test statistic
}
\description{
This function allows you to make Enders and Siklos(2001) nonlinear cointegration test
}
\examples{
x <- cumsum(rnorm(1000))
y <- cumsum(rnorm(1000))
Enders_Siklos_2001(x, y, max_lags = 6)

data(MarketPrices)
Enders_Siklos_2001(MarketPrices[,1],MarketPrices[,2], max_lags = 12)

}
\references{
Enders, W., & Siklos, P. L. (2001). Cointegration and threshold adjustment. Journal of Business & Economic Statistics, 19(2), 166-176.


Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{cointegration}
\keyword{nonlinear}
\keyword{test}
