% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Vougas_2006_unit_root.R
\name{Vougas_2006_unit_root}
\alias{Vougas_2006_unit_root}
\title{Vougas(2006) nonlinear unit root test function}
\usage{
Vougas_2006_unit_root(x, model, max_lags)
}
\arguments{
\item{x}{series name,}

\item{model}{if model A 1, if model B 2, if model C 3, model D 4, model E 5}

\item{max_lags}{maximum lag(optimal lag selected by AIC)}
}
\value{
"Model" Estimated model

"Selected lag" the lag order

"Test Statistic" the value of the test statistic
}
\description{
This function allows you to make Vougas(2006) nonlinear unit root test
}
\examples{
\donttest{
set.seed(12345)
x <- rnorm(1000)
Vougas_2006_unit_root(x, model = 1, max_lags = 6)

set.seed(12345)
y <- cumsum(rnorm(1000))
Vougas_2006_unit_root(x = y ,model = 2, max_lags = 9)


data(IBM)
Vougas_2006_unit_root(x = IBM, model = 3, max_lags = 3)

}

}
\references{
Vougas, D. V. (2006). On unit root testing with smooth transitions. Computational statistics & data analysis, 51(2), 797-800.


Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{nonlinear}
\keyword{root}
\keyword{test}
\keyword{unit}
