/* Created by Ville-Petteri Makinen 2003-2010
   Copyright (C) V-P Makinen
   All rights reserved */

#include "medusa.local.h"
#include <Rcpp.h>

/*
 * Print a warning message.
 */
void
medusa::worry(const string& msg, const char* fname) {
  mdsize len = msg.size();
  if(len < 1) return;

  /* Remove path from file name. */
  char* ptr = strrchr((char*)fname, '/');
  if(ptr == NULL) ptr = strrchr((char*)fname, '\\');
  if(ptr == NULL) ptr = (char*)fname;
  else ptr++;

  /* Show messages. */
  if(strlen(fname) == 0) {
    Rcpp::warning(msg);
  }
  else {
    Rcpp::warning(string(ptr) + ": " + msg);
  }
}
