% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magnesium.R
\name{calc_magnesium_availability}
\alias{calc_magnesium_availability}
\title{Calculate the capacity of soils to supply Magnesium}
\usage{
calc_magnesium_availability(
  B_LU_BRP,
  B_SOILTYPE_AGR,
  A_SOM_LOI,
  A_CLAY_MI,
  A_PH_CC,
  A_CEC_CO,
  A_K_CO_PO,
  A_MG_CC,
  A_K_CC
)
}
\arguments{
\item{B_LU_BRP}{(numeric) The crop code from the BRP}

\item{B_SOILTYPE_AGR}{(character) The agricultural type of soil}

\item{A_SOM_LOI}{(numeric) The percentage organic matter in the soil (\%)}

\item{A_CLAY_MI}{(numeric) The clay content of the soil (\%)}

\item{A_PH_CC}{(numeric) The acidity of the soil, measured in 0.01M CaCl2 (-)}

\item{A_CEC_CO}{(numeric) The cation exchange capacity of the soil (mmol+ per kg), analyzed via Cobalt-hexamine extraction}

\item{A_K_CO_PO}{(numeric) The occupation of the CEC with potassium (\%)}

\item{A_MG_CC}{(numeric) The plant available content of Mg in the soil (mg  Mg per kg) extracted by 0.01M CaCl2}

\item{A_K_CC}{(numeric) The plant available potassium, extracted with 0.01M CaCl2 (mg per kg),}
}
\value{
An index representing the availability of Magnesium in a soil. A numeric value.
}
\description{
This function calculates an index for the availability of Magnesium in soil
}
\examples{
calc_magnesium_availability(B_LU_BRP = 265, B_SOILTYPE_AGR = 'dekzand',
A_SOM_LOI = 3.5,A_CLAY_MI = 8.5,A_PH_CC = 5.4, 
A_CEC_CO = 185,A_K_CO_PO = 4.5,A_MG_CC = 125,A_K_CC = 65)

}
