% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterretention.R
\name{pFpara_ptf_Wosten1999}
\alias{pFpara_ptf_Wosten1999}
\title{Estimate water retention curve parameters based on Wosten 1999}
\usage{
pFpara_ptf_Wosten1999(Pklei, Psilt, Psom, Bovengrond)
}
\arguments{
\item{Pklei}{(numeric) The clay content of the soil (\%) within soil mineral part. Pklei > 0}

\item{Psilt}{(numeric) The silt content of the soil (\%) within soil mineral part. Psilt > 0}

\item{Psom}{(numeric) The organic matter content of the soil (\%). Psom > 0}

\item{Bovengrond}{(boolean) whether topsoil (1) or not (0)}
}
\value{
a table with the following columns:

Dichtheid (numeric) soil bulk density (g/cm3)
ThetaR (numeric) residual water content (cm3/cm3)
ThetaS (numeric) saturated water content (cm3/cm3)
alfa (numeric)  related to the inverse of the air entry suction, alfa > 0 (1/cm) 
n (numeric)  a measure of the pore-size distribution, n>1, dimensionless
ksat (numeric) saturated hydraulic conductivity (cm/d)
}
\description{
This function estimates water retention curve parameters using Pedo transfer function of Wosten (1999) based on HYPRES
}
\examples{
pFpara_ptf_Wosten1999(Pklei = 25, Psilt = 15, Psom = 4.5, Bovengrond = 1)
pFpara_ptf_Wosten1999(Pklei = 45, Psilt = 3, Psom = 4.5, Bovengrond = 1)

}
\references{
Wösten, J.H.M , Lilly, A., Nemes, A., Le Bas, C. (1999) Development and use of a database of hydraulic properties of European soils. Geoderma 90 (3-4): 169-185.
}
