% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{moment.test}
\alias{moment.test}
\title{test whether the k-th moment exists}
\usage{
moment.test(x, k = 16, R = 400)
}
\arguments{
\item{x}{a numeric vector of data samples.}

\item{k}{a number no smaller than 4, indicating that the procedure will test
the existence of the k-th moment when k is even. Otherwise, the procedure
will test the existence of the \eqn{k'}-th moment, with
\eqn{k'=round(k/2,0)\times 2}.}

\item{R}{the number of standard Gaussian variables generated in the
randomized test; see more details in Trapani (2016).}
}
\value{
a scalar in \eqn{[0,1]}, indicating the p-value
of the test. The null hypothese is that the k-th moment doesn't exist.
Therefore, a small p-value indicates the existense of the k-th moment.
}
\description{
This function tests the existence of k-th moment by randomized method in
Trapani (2016).
}
\details{
The procedure is adapted from Trapani (2016) with \eqn{\psi=2}, where
\eqn{\psi} is a tuning parameter to scale the sample moments defined
in Section 3.1 of Trapani (2016). For simplicity, we only test the 4th, 6th,
... 2c-th moments.
}
\examples{

x=rt(10000,5)
moment.test(x,4)

x=rt(10000,4)
moment.test(x,4)

}
\references{
Trapani, L. (2016). Testing for (in) finite moments.
\emph{Journal of Econometrics}, 191(1), 57-68.
}
\author{
Yong He, Xinbing Kong, Lorenzo Trapani, Long Yu
}
