% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ONEST_main.R
\name{ONEST_main}
\alias{ONEST_main}
\title{ONEST main function}
\usage{
ONEST_main(data)
}
\arguments{
\item{data}{a matrix containing the binary pathology data. Each row is the data from one case, and each column is the data from one rater. Missing values are allowed and can be denoted as NA or left blank. If there are n cases and k raters, the input ‘data’ is a matrix with dimension n by k.}
}
\value{
consist_p: a vector of length k-1, indicating proportion of identical reads among a set of pathologists. For example, the first element of “consist_p” is the estimate of agreement percentage for 2 raters. The k-1 th element is the estimate of agreement percentage for k raters.

consist_low: a vector of length k-1, indicating the lower bound of the agreement percentage with 95 percent confidence level corresponding to “consist_p”.

diff_consist: a vector of length k-2, indicating the difference between the consist_p. For example, the first element of “diff_consist” is the estimated difference of agreement percentage after increasing from 2 to 3 raters. The k-2 th element is the difference of agreement percentage after increasing from k-1 to k raters.

diff_high: a vector of length k-2, indicating the upper bound of the change of agreement percentage corresponding to “diff_consist” with 95 percent confidence level.

size_case: number of cases n

size_rater: number of raters k

p: the probability of of being rated positive among the proportion of ‘1-p_plus-p_minus’ cases.

p_plus: proportion of the cases rated positive by all raters.

p_minus: proportion of the cases rated negative by all raters.

empirical: a matrix of dimension k-1 by 3, including the empirical estimate of the agreement percentage, and the empirical 95 percent confidence intervals (CI) of the agreement percentage with equal tail probabilities on the two sides. The empirical estimate and CI were calculated by permuting the raters with 1000 random permutations, and using the mean, 2.5th percentile, and 97.5th percentile.
}
\description{
This is the ONEST main function taking binary (0/1) pathology data as input. This function
utilizes the plotline function to produce the ONEST graphs and estimates.
}
\examples{
data("sp142_bin")
\donttest{ONEST_main(sp142_bin)}
}
