% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spcrl.R
\name{spcrl}
\alias{spcrl}
\title{The stochastic principal  component  regression with varying learning-rate can handle online data sets.}
\usage{
spcrl(data, m, eta, alpha)
}
\arguments{
\item{data}{is a online data set}

\item{m}{is the number of principal component}

\item{eta}{is the proportion of online data to total data}

\item{alpha}{is the step size}
}
\value{
T2,T2k,V,Vhat,lambdahat,time
}
\description{
The stochastic principal  component  regression with varying learning-rate can handle online data sets.
}
\examples{
# Load necessary libraries
library(MASS)
library(Matrix)
library(car)
# Set seed for reproducibility
set.seed(1234)

# Define sample size, number of variables and number of principal component
n = 2000
p = 10
m=9
# Mean vector
mu0 = runif(p, 0)

# Method 1: Generate a positive-definite matrix using the Wishart distribution
Sigma0 = rWishart(1, df = p, Sigma = diag(p))[,,1]

# Method 2: Manually construct a positive-definite matrix
# A = matrix(rnorm(p^2), nrow = p)
# Sigma0 = A %*% t(A) + diag(p) * 10

# Method 3: Adjust an existing matrix to be positive-definite
# Sigma0 = nearPD(Sigma0)$mat

# Generate multivariate normal data
x = mvrnorm(n, mu0, Sigma0)
colnames(x)<-paste("x",1:p,sep="")
e=rnorm(n,0,1)
B = sample(1:3,(p+1),replace = TRUE) 
en<-matrix(rep(1,n*1),ncol=1)
y=cbind(en,x)%*%B+e
colnames(y)<-paste("y", 1:ncol(y), sep="")
data<-data.frame(cbind(y,x))
spcrl(data=data,m=m,eta=0.8,alpha=0.5)
}
