% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KowaAP7000Client.r
\name{opiInitialise_for_KowaAP7000}
\alias{opiInitialise_for_KowaAP7000}
\title{Implementation of opiInitialise for the Octopus900 machine.}
\arguments{
\item{ip}{IP address of AP7000 machine (as string)}

\item{port}{Port number on which AP7000 server is listening}
}
\value{
\code{list(err = NULL)}
}
\description{
This is for internal use only. Use \code{\link[=opiInitialise]{opiInitialise()}} with
these Arguments and you will get the Value back.
}
\details{
If the chosen OPI implementation is \code{KowaAP7000}, then you must specify
the IP address and port of the AP-7000 server.
}
\examples{
\dontrun{
  # Set up the Kowa AP-7000
  chooseOpi("KowaAP7000")
  opiInitialize(ip="192.168.1.7", port=44965)
}
}
