% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryGroupwise.R
\name{summaryGroupwise}
\alias{summaryGroupwise}
\title{Overview Class Groups}
\usage{
summaryGroupwise(subcascades = NULL, maxCl = 50)
}
\arguments{
\item{subcascades}{A Subcascades object as it is returned by \code{\link{subcascades}}-function.
The Subcascades object is made up of a list of matrices.
Each matrix comprises the evaluation results of cascades of a specific length and
is sorted row-wise according to the achieved minimal classwise sensitivities of the cascades (decreasing).
The rownames show the class order by a character string of type '1>2>3' and the entries the sensitivity for each position of the cascade.}

\item{maxCl}{An integer defining the lower bound for the maximal number of classes. Has only to be set if the analyzed dataset has more than 50 classes.}
}
\value{
A matrix summarizing the overview characteristics of the Groupwise object.
}
\description{
\code{summaryGroupwise} returns a summarizing overview. For each length the number of permutations consisting of the same set of classes is given.
}
\details{
This function gives an overview of the subgroup characteristics of the Subcascades object.
The number of permutations per size is given. A permutation means that the corresponding cascades contain the same classes but with different order.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
genMap = gen.predictionMap(data, labels, foldList = foldList, 
classifier = tunePareto.svm(), kernel='linear')
# generate Subcascades object
subcascades = subcascades(genMap,thresh=0.7)

summaryGroupwise(subcascades)

}
\seealso{
\code{\link{subcascades}}, \code{\link{summarySubcascades}}, \code{\link{summaryClasses}}
}
