% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OT_outcome.r
\name{OT_outcome}
\alias{OT_outcome}
\alias{ot_outcome}
\alias{OT}
\title{OT_outcome()}
\usage{
OT_outcome(
  datab,
  index_DB_Y_Z = 1:3,
  quanti = NULL,
  nominal = NULL,
  ordinal = NULL,
  logic = NULL,
  convert.num = NULL,
  convert.clss = NULL,
  FAMD.coord = "NO",
  FAMD.perc = 0.8,
  dist.choice = "E",
  percent.knn = 1,
  maxrelax = 0,
  indiv.method = "sequential",
  prox.dist = 0,
  solvR = "glpk",
  which.DB = "BOTH"
)
}
\arguments{
\item{datab}{a data.frame made up of two overlayed databases with at least four columns sorted in a random order. One column must be a column dedicated to the identification of the two databases ranked in ascending order
(For example: 1 for the top database and 2 for the database from below, or more logically here A and B  ...But not B and A!). One column (\eqn{Y} here but other names are allowed)
must correspond to the target variable related to the information of interest to merge with its specific encoding in the database A (corresponding encoding should be missing in the database B). In the same way,
one column (\eqn{Z} here) corresponds to the second target variable with its specific encoding in the database B (corresponding encoding should be missing in the database A).
Finally, the input database must have at least one shared covariate with same encoding in A and B. Please notice that, if your data.frame has only one shared covariate (four columns) with missing values (because no imputation is desired)
then a warning will appear and the algorithm will only run with complete cases.}

\item{index_DB_Y_Z}{a vector of three indexes of variables. The first index must correspond to the index of the databases identifier column. The second index corresponds
to the index of the target variable in the first database (A) while the third index corresponds to the column index related to the target variable in the second database (B).}

\item{quanti}{a vector of column indexes of all the quantitative variables (database identifier and target variables included if it is the case for them).}

\item{nominal}{a vector of column indexes of all the nominal (not ordered) variables (database identifier and target variables included if it is the case for them).}

\item{ordinal}{a vector of column indexes of all the ordinal variables (database identifier and target variables included if it is the case for them).}

\item{logic}{a vector of column indexes of all the boolean variables of the data.frame.}

\item{convert.num}{indexes of the continuous (quantitative) variables to convert in ordered factors if necessary. All declared indexes in this argument must have been declared in the argument \code{quanti} (no conversion by default).}

\item{convert.clss}{a vector indicating for each continuous variable to convert, the corresponding desired number of levels. If the length of the argument \code{convert_num} exceeds 1 while the length of \code{convert_clss} equals 1 (only one integer),
each discretization will count the same number of levels (quantiles).}

\item{FAMD.coord}{a logical that must be set to TRUE when user decides to work with principal components of a factor analysis for mixed data (FAMD) instead of the set of raw covariates (FALSE is the default value).}

\item{FAMD.perc}{a percent (between 0 and 1) linked to the \code{FAMD.coord} argument (0.8 is the default value). When this latter equals TRUE, this argument corresponds to the minimum part of variability that must be taken into account by the principal components of the FAMD method.
This option fixes the remaining number of principal components for the rest of the study.}

\item{dist.choice}{a character string (with quotes) corresponding to the distance function chosen between: the euclidean distance ("E", by default), The Manhattan distance ("M"),
the Gower distance ("G"), the Hamming distance ("H") for binary covariates only, and the Euclidean or Manhattan distance computed from principal components of a factor analysis of mixed data ("FAMD"). See (1) for details.}

\item{percent.knn}{the ratio of closest neighbors involved in the computations of the cost matrices. 1 is the default value that includes all rows in the computation.}

\item{maxrelax}{the maximum percentage of deviation from expected probability masses. It must be equal to 0 (default value) for the \code{OUTCOME} algorithm, and equal to a strictly positive value for the R-OUTCOME algorithm. See (2) for details.}

\item{indiv.method}{a character string indicating the chosen method to get individual predictions from the joint probabilities assessed, "sequential" by default, or "optimal". See the \code{details} section and (2) for details.}

\item{prox.dist}{a probability (between 0 and 1) used to calculate the distance threshold below which an individual (a row) is considered as a neighbor of a given profile of covariates. When shared variables are all factors or categorical, it is suggested to keep this option to 0.}

\item{solvR}{a character string that specifies the type of method selected to solve the optimization algorithms. The default solver is "glpk".}

\item{which.DB}{a character string indicating the database to complete ("BOTH" by default, for the prediction of \eqn{Y} and \eqn{Z} in the two databases), "A" only for the imputation of \eqn{Z} in A, "B" only for the imputation of \eqn{Y} in B.}
}
\value{
A "otres" class object of 9 elements:
\item{time_exe}{the running time of the function}
\item{gamma_A}{a matrix corresponding to an estimation of the joint distribution of \eqn{(Y,Z)} in A}
\item{gamma_B}{a matrix corresponding to an estimation of the joint distribution of \eqn{(Y,Z)} in B}
\item{profile}{a data.frame that gives all details about the remaining \eqn{P} profiles of covariates. These informations can be linked to the \code{estimatorZA} and the \code{estimatorYB} objects for a better interpretation of the results.}
\item{res_prox}{the outputs of the function \code{proxim_dist}}
\item{estimatorZA}{an array that corresponds to estimates of the probability distribution of \eqn{Z} conditional to \eqn{X} and \eqn{Y} in database A. The number of rows of each table corresponds to the total number of profiles of covariates.
The first dimension of each table (rownames) correspond to the profiles of covariates sorted by order of appearance in the merged database. The second dimension of the array (columns of the tables) corresponds to the levels of \eqn{Y} while the third element corresponds to the levels of \eqn{Z}.}
\item{estimatorYB}{an array that corresponds to estimates of the probability distribution of \eqn{Y} conditional to \eqn{X} and \eqn{Z} in database B. The number of rows of each table corresponds to the total number of profiles of covariates.
The first dimension of each table (rownames) correspond to the profiles of covariates sorted by order of appearance in the merged database. The second dimension of the array (columns of the tables) corresponds to the levels of \eqn{Z} while the third element corresponds to the levels of \eqn{Y}.}
\item{DATA1_OT}{the database A with the individual predictions of \eqn{Z} using an optimal transportation algorithm (\code{OUTCOME}) or \code{R-OUTCOME}}
\item{DATA2_OT}{the database B with the individual predictions of \eqn{Y} using an optimal transportation algorithm (\code{OUTCOME}) or \code{R-OUTCOME}}
}
\description{
The function \code{OT_outcome} integrates two algorithms called (\code{OUTCOME}) and (\code{R-OUTCOME}) dedicated to the solving of recoding problems in data fusion
using optimal transportation (OT) of the joint distribution of outcomes.
}
\details{
A. THE RECODING PROBLEM IN DATA FUSION

Assuming that \eqn{Y} and \eqn{Z} are two target variables which refered to the same target population in two separate databases A and B respectively (no overlapping rows),
so that \eqn{Y} and \eqn{Z} are never jointly observed. Assuming also that A and B share a subset of common covariates \eqn{X} of any types (same encodings in A and B)
completed or not. Merging these two databases often requires to solve a recoding problem by creating an unique database where
the missing information of \eqn{Y} and \eqn{Z} is fully completed.


B. INFORMATIONS ABOUT THE ALGORITHM

The algorithm integrated in the function \code{OT_outcome} provides a solution to the recoding problem previously described by proposing an
application of optimal transportation which aims is to search for a bijective mapping between the distributions of of \eqn{Y} in A and \eqn{Z} in B.
Mathematically, the principle of the algorithm is based on the resolution of an optimization problem which provides an optimal solution \eqn{\gamma} (as called in the related articles)
that transfers the distribution of \eqn{Y} in A to the distribution of \eqn{Z} in B (or conversely, according to the sense of the transport)and can be so interpreted as an estimator of the joint distribution
\eqn{(Y,Z)} in A (or B respetively). According to this result, a second step of the algorithm provides individual predictions of \eqn{Y} in B (resp. of \eqn{Z} in A, or both, depending on the choice
specified by user in the argument \code{which.DB}). Two possible approaches are available depending on the argument \code{indiv.method}:
\itemize{
\item When \code{indiv.method = "sequential"}, a nearest neighbor procedure is applied. This corresponds to the use of the function \code{\link{indiv_grp_closest}}
implemented in the function \code{OT_outcome}.
\item When \code{indiv.method = "optimal"}, a linear optimization problem is solved to determine the individual predictions that minimize the sum of the individual distances
in A (resp. in B) with the modalities of \eqn{Z} in B (resp. \eqn{Y} in A). This approach is applied via the function \code{\link{indiv_grp_optimal}} implemented in the function \code{OT_outcome}.
}
This algorithm supposes the respect of the two following assumptions:
\enumerate{
\item \eqn{Y} must follow the same distribution in A and B. In the same way, \eqn{Z} follows the same distribution in the two databases.
\item The conditional distribution \eqn{(Y|X)} must be identical in A and B. Respectively, \eqn{(Z|X)} is supposed identical in A and B.
}
Because the first assumption can be too strong in some situations, a relaxation of the constraints of marginal distribution is possible using the argument \code{maxrelax}.
When \code{indiv.method = "sequential"} and \code{maxrelax = 0}, the algorithm called \code{OUTCOME} (see (1) and (2))
is applied. In all other situations, the algorithm applied corresponds to an algorithm called \code{R_OUTCOME} (see (2)).
A posteriori estimates of conditional probabilities \eqn{P[Y|X,Z]} and \eqn{P[Z|X,Y]} are available for each profile of covariates (see the output objects \code{estimatorYB} and \code{estimatorZA}).
Estimates of \eqn{\gamma} are also available according to the desired direction of the transport (from A to B and/or conversely. See \eqn{\gamma_A} and \eqn{\gamma_B}).


C. EXPECTED STRUCTURE FOR THE INPUT DATABASE

The input database is a data.frame that must be saved in a specific form by users:
\itemize{
\item Two overlayed databases containing a common column of database identifiers (A and B, 1 or 2, by examples, encoded in numeric or factor form)
\item A column corresponding to the target variable with its specific encoding in A (For example a factor \eqn{Y} encoded in \eqn{n_Y} levels, ordered or not, with NAs in the corresponding rows of B)
\item A column corresponding to the second target outcome with its specific endoded in B (For example a factor \eqn{Z} in \eqn{n_Z} levels, with NAs in rows of A)
\item The order of the variables in the database have no importance but the column indexes related to the three columns previously described (ie ID, \eqn{Y} and \eqn{Z}) must be rigorously specified
in the argument \code{index_DB_Y_Z}.
\item A set of shared common covariates (at least one but more is recommended) of any type, complete or not (provided that the number of covariates exceeds 1) is required.
}
The function \code{\link{merge_dbs}} is available in this package to assist user in the preparation of their databases, so please, do not hesitate to use it beforehand if necessary.

Remarks about the target variables:
\itemize{
\item A target variable can be of categorical type, but also discrete, stored in factor, ordered or not. Nevertheless, notice that, if the variable is stored in numeric it will be automatically converted in ordered factors.
\item If a target outcome is incomplete, the corresponding rows will be automatically dropped during the execution of the function.
}
The type of each variables (including \eqn{ID}, \eqn{Y} and \eqn{Z}) of the database must be rigorously specified once, in one of the four arguments \code{quanti},\code{nominal}, \code{ordinal} and \code{logic}.


D. TRANSFORMATIONS OF CONTINUOUS COVARIATES

The function \code{OT_outcome} integrates in its syntax a process dedicated to the categorization of continuous covariates. For this, it is necessary to rigorously fill in the arguments \code{convert.num} and \code{convert.clss}.
The first one informs about the indexes in database of the continuous variables to transform in ordered factor while the second one specifies the corresponding number of desired balanced levels (for unbalanced levels, users must do transformations by themselves).
Therefore \code{convert.num} and \code{convert.clss} must be vectors of same length, but if the length of \code{convert.num} exceeds 1, while the length of \code{convert.clss} is 1, then, by default, all the covariates to convert will have the same number of classes,
that corresponds to the value specified in the argument \code{convert.clss}.
Please notice that only covariates can be transformed (not outcomes) and missing informations are not taken into account for the transformations.
Moreover, all the indexes informed in the argument \code{convert.num} must also be informed in the argument \code{quanti}.


E. INFORMATIONS ABOUT DISTANCE FUNCTIONS

Each individual (or row) of a given database is here characterized by their covariates, so the distance between two individuals or groups of individuals depends on similarities between covariates
according to the distance function chosen by user (via the argument \code{dist.choice}). Actually four distance functions are implemented in \code{OT_outcome} to take into account the most frequently encountered situation (see (3)):
\itemize{
\item the Manhattan distance ("M")
\item the Euclidean distance ("E")
\item the Gower distance for mixed data (see (4): "G")
\item the Hamming distance for binary data ("H")
}
Moreover, it is also possible to directly apply the first three distances mentioned on coordinates extracted from a multivariate analysis (Factor Analysis for Mixed Data, see (5)) applied on raw covariates using the arguments \code{FAMD.coord} and \code{FAMD.perc}.
This method is used (1).

As a decision rule, for a given profile of covariates \eqn{P_j}, an individual \eqn{i} will be considered as a neighbor of \eqn{P_j} if \eqn{dist(i,P_j) < \mbox{prox.dist} \times max(dist(i,P_j))} where \eqn{prox.dist} must be fixed by user.


F. INFORMATIONS ABOUT THE SOLVER

The argument \code{solvR} permits user to choose the solver of the optimization algorithm. The default solver is "glpk" that corresponds to the GNU Linear Programming Kit (see (6) for more details).
Moreover, the function actually uses the \code{R} optimization infrastructure of the package \pkg{ROI} which offers a wide choice of solver to users by easily loading the associated plugins of \pkg{ROI} (see (7)).

For more details about the algorithms integrated in \code{OT_outcome}, please consult (1) and (2).
}
\examples{

### Using a sample of simu_data dataset
### Y and Z are a same variable encoded in 2 different forms:
### (3 levels for Y and 5 levels for Z)
#--------
data(simu_data)
simu_dat  = simu_data[c(1:200,301:500),]

### An example of OUTCOME algorithm that uses:
#-----
# - A nearest neighbor procedure for the estimation of individual predictions
# - The Manhattan distance function
# - 90\% of individuals from each modalities to calculate average distances
#   between individuals and modalities
# Predictions are assessed for Y in B and Z in A
#-----

try1 = OT_outcome(simu_dat, quanti = c(3,8), nominal = c(1,4:5,7), ordinal = c(2,6),
                  dist.choice = "M", maxrelax = 0,
                  indiv.method = "sequential")
head(try1$DATA1_OT)  # Part of the completed database A
head(try1$DATA2_OT)  # Part of the completed database B

head(try1$estimatorZA[,,1])
# ... Corresponds to P[Z = 1|Y,P1] when P1 corresponds to the 1st profile of covariates (P_1)
# detailed in the 1st row of the profile object:
try1$profile[1,]   # Details of P_1

# So estimatorZA[1,1,1]= 0.2 corresponds to an estimation of:
# P[Z = 1|Y=[20-40],Gender_2=0,Treatment_2=1,Treatment_3=0,Smoking_2=1,Dosage=3,Age=65.44]
# Thus, we can conclude that all individuals with the P_1 profile of covariates have
# 20\% of chance to be affected to the 1st level of Z in database A.
# ... And so on, the reasoning is the same for the estimatorYB object.


\donttest{

### An example of OUTCOME algorithm with same conditions as the previous example, excepted that;
# - Only the individual predictions of Y in B are required
# - The continuous covariates "age" (related index = 8) will be converted in an ordinal factors
#   of 3 balanced classes (tertiles)
# - The Gower distance is now used
###-----

try2 = OT_outcome(simu_dat, quanti = c(3,8), nominal = c(1,4:5,7), ordinal = c(2,6),
                  dist.choice = "G", maxrelax = 0,
                  convert.num = 8, convert.clss = 3,
                  indiv.method = "sequential", which.DB = "B")


### An example of OUTCOME algorithm with same conditions as the first example, excepted that;
# - Only the individual predictions of Z in A are required
# - The continuous covariates "age" (related index = 8) will be converted in an ordinal factors
#   of 3 balanced classes (tertiles)
# - Here, the Hamming distance can be applied because, after conversion, all covariates are factors.
#   Disjunctive tables of each covariates will be automatically used to work with a set of binary
#   variables.
###-----

try3 = OT_outcome(simu_data, quanti = c(3,8), nominal = c(1,4:5,7), ordinal = c(2,6),
                  dist.choice = "H", maxrelax = 0,
                  convert.num = 8, convert.clss = 3,
                  indiv.method = "sequential",which.DB = "B")


### An example of R-OUTCOME algorithm using:
# - An optimization procedure for individual predictions on the 2 databases
# - The Manhattan distance
# - Raw covariates
###-----
try4 = OT_outcome(simu_data, quanti = c(3,8), nominal = c(1,4:5,7), ordinal = c(2,6),
                  dist.choice = "M", maxrelax = 0,
                  indiv.method = "optimal")


### An example of R-OUTCOME algorithm with:
# - An optimization procedure for individual predictions on the 2 databases
# - The use of Euclidean distance on coordinates from FAMD
# - Raw covariates
###-----

try5 = OT_outcome(simu_data, quanti = c(3,8), nominal = c(1,4:5,7), ordinal = c(2,6),
                  dist.choice = "E",
                  FAMD.coord = "YES", FAMD.perc = 0.8,
                  indiv.method = "optimal")


### An example of R-OUTCOME algorithm with relaxation on marginal distributions and:
# - An optimization procedure for individual predictions on the 2 databases
# - The use of the euclidean distance
# - An arbitrary coefficient of relaxation
# - Raw covariates
#-----

try6 = OT_outcome(simu_data, quanti = c(3,8), nominal = c(1,4:5,7), ordinal = c(2,6),
                  dist.choice = "E", maxrelax = 0.4,
                  indiv.method = "optimal")


}

}
\references{
\enumerate{
\item Gares V, Dimeglio C, Guernec G, Fantin F, Lepage B, Korosok MR, savy N (2019). On the use of optimal transportation theory to recode variables and application to database merging. The International Journal of Biostatistics.
Volume 16, Issue 1, 20180106, eISSN 1557-4679. doi:10.1515/ijb-2018-0106
\item Gares V, Omer J (2020) Regularized optimal transport of covariates and outcomes in data recoding. Journal of the American Statistical Association. \doi{10.1080/01621459.2020.1775615}
\item Anderberg, M.R. (1973), Cluster analysis for applications, 359 pp., Academic Press, New York, NY, USA.
\item Gower J.C. (1971). A general coefficient of similarity and some of its properties. Biometrics, 27, 623–637.
\item Pages J. (2004). Analyse factorielle de donnees mixtes. Revue Statistique Appliquee. LII (4). pp. 93-111.
\item Makhorin A (2011). GNU Linear Programming Kit Reference Manual Version 4.47.\url{http://www.gnu.org/software/glpk/}
\item Theussl S, Schwendinger F, Hornik K (2020). ROI: An Extensible R Optimization Infrastructure.Journal of Statistical Software,94(15), 1-64. \doi{10.18637/jss.v094.i15}
}
}
\seealso{
\code{\link{transfo_dist}},\code{\link{proxim_dist}}, \code{\link{avg_dist_closest}}, \code{\link{indiv_grp_closest}}, \code{\link{indiv_grp_optimal}}
}
\author{
Gregory Guernec, Valerie Gares, Jeremy Omer

\email{otrecod.pkg@gmail.com}
}
