% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{PIsol}
\alias{PIsol}
\title{A function to compute multigroup normalised isolation index (PIsol)}
\usage{
PIsol(x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
Multigroup normalised isolation index
}
\description{
Multigroup version of isolation index (\code{\link{xPx}})
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
PIsol(x)
}
\references{
Massey D. S. and Denton N. A. (1988) \emph{The
dimensions of residential segregation}.
Social Forces 67(2),  pp. 281-315.
}
\seealso{
Other multigroup exposition indices:  \code{\link{RelDivers}}

Other multigroup indices:
\code{\link{HShannon}}, \code{\link{JPielou}}, \code{\link{ISimpson}},
\code{\link{GiniMulti}}, \code{\link{DMulti}}
}

