% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{DPxx}
\alias{DPxx}
\title{A function to compute the distance-decay isolation index (DPxx)}
\usage{
DPxx(x, d = NULL, distin = 'm',  distout = 'm', diagval = '0', 
spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a population group, within 
spatial units. The number of columns should be greater than 1 (at least 2 
population groups are required). You should not include a column with total 
population in each unit, because this will be interpreted as a group.}

\item{d}{- a matrix of the distances between spatial unit centroids}

\item{distin}{- input metric conversion, based on  \pkg{bink} package and 
includes conversions from 'm', 'km', 'inch', 'ft', 'yd', 'mi', 'naut_mi', etc.}

\item{distout}{- output metric conversion, based on  \pkg{bink} package and 
includes conversions to 'm', 'km', 'inch', 'ft', 'yd', 'mi', 'naut_mi', etc.}

\item{diagval}{- when providing a spatial object or a shape file, 
the user has the choice of the spatial matrix diagonal definition: 
diagval = '0' (by default) for an null diagonal and diagval = 'a' 
to compute the diagonal as 0.6 * square root (spatial units area) (White, 1983)}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame) containing 
geographic information}

\item{folder}{- a character vector with the folder (directory) 
name indicating where the shapefile with the geographic information 
is located.}

\item{shape}{- a character vector with the name of the shapefile 
(without the .shp extension) which contains the geographic information}
}
\value{
a numeric vector containing the distance-decay isolation index 
value for each population group
}
\description{
The distance decay isolation index, DPxx, is a spatial
adaptation of isolation index \code{\link{xPx}}. 
The function can be used in two ways: to provide a distance matrix 
or a external geographic information source (spatial object or shape file).
}
\examples{
x <- segdata@data[ ,1:2]
ar <- area(segdata)
dist <- distance(segdata)
diag(dist)<-sqrt(ar) * 0.6
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'segdata'

DPxx(x, d = dist)

DPxx(x, spatobj = segdata, diagval = 'a')

DPxx(x, folder = foldername, shape = shapename, diagval = '0') 
}
\references{
Morgan, B. S. (1983) \emph{A Distance-Decay Based Interaction 
Index to Measure Residential Segregation}. Area 15(3),  pp. 211-217.
}
\seealso{
Isolation indices: 
\code{\link{xPx}},  \code{\link{Eta2}}

Interaction indices: 
\code{\link{xPy}}, \code{\link{DPxy}}
}

