/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.comparator;

import org.andwellness.xml.datagenerator.comparator.DataPointComparator;
import org.andwellness.xml.datagenerator.comparator.HoursBeforeNowDataPointComparator;
import org.andwellness.xml.datagenerator.comparator.MultiChoiceCustomDataPointComparator;
import org.andwellness.xml.datagenerator.comparator.MultiChoiceDataPointComparator;
import org.andwellness.xml.datagenerator.comparator.NumberDataPointComparator;
import org.andwellness.xml.datagenerator.comparator.RemoteActivityDataPointComparator;
import org.andwellness.xml.datagenerator.comparator.SingleChoiceCustomDataPointComparator;
import org.andwellness.xml.datagenerator.comparator.SingleChoiceDataPointComparator;
import org.andwellness.xml.datagenerator.model.DataPoint;

public final class DataPointComparatorFactory {
    private DataPointComparatorFactory() {
    }

    public static DataPointComparator createDataPointComparator(DataPoint.PromptType promptType) {
        switch (promptType) {
            case single_choice: {
                return new SingleChoiceDataPointComparator();
            }
            case single_choice_custom: {
                return new SingleChoiceCustomDataPointComparator();
            }
            case multi_choice: {
                return new MultiChoiceDataPointComparator();
            }
            case multi_choice_custom: {
                return new MultiChoiceCustomDataPointComparator();
            }
            case number: {
                return new NumberDataPointComparator();
            }
            case hours_before_now: {
                return new HoursBeforeNowDataPointComparator();
            }
            case remote_activity: {
                return new RemoteActivityDataPointComparator();
            }
        }
        throw new IllegalArgumentException("No comparator defined for this prompt type.");
    }
}

