/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.utility;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TextToJson {
    private static String _helpText = "Given a JSON type (object or array) and an input file name, attempt to convert the file's\ncontents to pretty-printed JSON and push the JSON to System.out.\n  Usage:\n      java edu.ucla.cens.genjson.TextToJson <array>|<object> fileName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws JSONException, IOException {
        String type;
        if (args.length < 2) {
            System.out.println("incorrect number of arguments");
            System.out.println(_helpText);
            System.exit(1);
        }
        if ("help".equals(args[0])) {
            System.out.println(_helpText);
            System.exit(0);
        }
        if (!"array".equals(type = args[0]) && !"object".equals(type)) {
            throw new IllegalArgumentException("invalid json type argument. you provided: " + type);
        }
        String fileName = args[1];
        StringBuilder builder = new StringBuilder();
        BufferedReader in = null;
        Writer out = null;
        try {
            in = new BufferedReader(new FileReader(fileName));
            out = new BufferedWriter(new OutputStreamWriter(System.out));
            String line = in.readLine();
            while (null != line) {
                builder.append(line);
                line = in.readLine();
            }
            if ("array".equals(type)) {
                JSONArray jsonArray = new JSONArray(builder.toString());
                out.write(jsonArray.toString(4));
            } else if ("object".equals(type)) {
                JSONObject jsonObject = new JSONObject(builder.toString());
                out.write(jsonObject.toString(4));
            }
            out.flush();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

