% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization_utils.R
\name{olink_norm_input_check_samples}
\alias{olink_norm_input_check_samples}
\title{Check reference samples to be used for normalization}
\usage{
olink_norm_input_check_samples(lst_df_samples, lst_ref_samples, norm_mode)
}
\arguments{
\item{lst_df_samples}{Named list of all sample identifiers from datasets to
be normalized.}

\item{lst_ref_samples}{Named list of reference sample identifiers to be used
for normalization.}

\item{norm_mode}{Character string indicating the type of normalization to be
performed. Expecting one of
bridge, subset, ref_median or norm_ht_3k. # nolint}
}
\value{
\code{NULL} if no warning or error.
}
\description{
This function takes as input a two named lists of character vectors with
matching names and checks the validity of the reference samples. In case of 1
set of df samples, then all checks are skipped as reference median
normalization is to be performed.
}
\examples{
\donttest{
# Reference median normalization
OlinkAnalyze:::olink_norm_input_check_samples(
  lst_df_samples = list(
    "p1" = unique(npx_data1$SampleID)
  ),
  lst_ref_samples = list(
    "p1" = npx_data1 |>
      dplyr::filter(
        !grepl(pattern = "CONTROL_SAMPLE",
        x = .data[["SampleID"]],
        fixed = TRUE)
      ) |>
      dplyr::pull(.data[["SampleID"]]) |>
      unique() |>
      sort() |>
      head(n = 6L)
  ),
  norm_mode = "ref_median"
)

# Bridge normalization
ref_samples_bridge <- intersect(x = npx_data1$SampleID,
                                y = npx_data2$SampleID) |>
  (\(x) x[!grepl(pattern = "CONTROL_SAMPLE", x = x, fixed = TRUE)])()

OlinkAnalyze:::olink_norm_input_check_samples(
  lst_df_samples = list(
    "p1" = unique(npx_data1$SampleID),
    "p2" = unique(npx_data2$SampleID)
  ),
  lst_ref_samples = list(
    "p1" = ref_samples_bridge,
    "p2" = ref_samples_bridge
  ),
  norm_mode = "bridge"
)

# Subset normalization
ref_samples_subset_1 <- npx_data1 |>
  dplyr::filter(
    !grepl(pattern = "CONTROL_SAMPLE",
           x = .data[["SampleID"]],
           fixed = TRUE)
    & .data[["QC_Warning"]] == "Pass"
  ) |>
  dplyr::pull(
    .data[["SampleID"]]
  ) |>
  unique()
ref_samples_subset_2 <- npx_data2 |>
  dplyr::filter(
    !grepl(pattern = "CONTROL_SAMPLE",
           x = .data[["SampleID"]],
           fixed = TRUE)
    & .data[["QC_Warning"]] == "Pass"
  ) |>
  dplyr::pull(
    .data[["SampleID"]]
  ) |>
  unique()

OlinkAnalyze:::olink_norm_input_check_samples(
  lst_df_samples = list(
    "p1" = unique(npx_data1$SampleID),
    "p2" = unique(npx_data2$SampleID)
  ),
  lst_ref_samples = list(
    "p1" = ref_samples_subset_1,
    "p2" = ref_samples_subset_2
  ),
  norm_mode = "subset"
)
}

}
\author{
Klev Diamanti
}
