% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotObservationPeriod.R
\name{plotObservationPeriod}
\alias{plotObservationPeriod}
\title{Create a plot from the output of summariseObservationPeriod().}
\usage{
plotObservationPeriod(
  result,
  variableName = "number subjects",
  plotType = "barplot",
  facet = NULL,
  colour = NULL
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{variableName}{The variable to plot it can be: "number subjects",
"records per person", "duration" or "days to next observation period".}

\item{plotType}{The plot type, it can be: "barplot", "boxplot" or
"densityplot".}

\item{facet}{Columns to colour by. See possible columns to colour by with:
\code{visOmopResults::tidyColumns()}.}

\item{colour}{Columns to colour by. See possible columns to colour by with:
\code{visOmopResults::tidyColumns()}.}
}
\value{
A ggplot2 object.
}
\description{
Create a plot from the output of summariseObservationPeriod().
}
\examples{
\donttest{
cdm <- mockOmopSketch(numberIndividuals = 100)

result <- summariseObservationPeriod(cdm$observation_period)

result |>
  plotObservationPeriod(
    variableName = "duration in days",
    plotType = "boxplot"
  )

PatientProfiles::mockDisconnect(cdm)
}
}
