% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneR_main.R
\name{OneR}
\alias{OneR}
\title{One Rule function}
\usage{
OneR(data, formula = NULL, ties.method = c("first", "chisq"),
  verbose = FALSE)
}
\arguments{
\item{data}{dataframe, which contains the data. When \code{formula = NULL} (the default) the last column must be the target variable.}

\item{formula}{formula interface for the \code{OneR} function.}

\item{ties.method}{a character string specifying how ties are treated, see 'Details'; can be abbreviated.}

\item{verbose}{If \code{TRUE} prints rank, names and predictive accuracy of the attributes in decreasing order (with \code{ties.method = "first"}).}
}
\description{
Builds a model according to the One Rule (OneR) machine learning classification algorithm.
}
\details{
All numerical data is automatically converted into five categorical bins of equal length. Instances with missing values are removed.
This is done by internally calling the default version of \code{\link{bin}} before starting the OneR algorithm.
To finetune this behaviour data preprocessing with the \code{\link{bin}} or \code{\link{optbin}} functions should be performed.

When there is more than one attribute with best performance either the first (from left to right) is being chosen (method \code{"first"}) or
the one with the lowest p-value of a chi-squared test (method \code{"chisq"}).
}
\examples{
data <- optbin(iris)
model <- OneR(data, verbose = TRUE)
summary(model)
plot(model)
prediction <- predict(model, data)
eval_model(prediction, data)

## The same with the formula interface:
data <- optbin(iris)
model <- OneR(formula = Species ~., data = data, verbose = TRUE)
summary(model)
plot(model)
prediction <- predict(model, data)
eval_model(prediction, data)
}
\author{
Holger von Jouanne-Diedrich
}
\references{
\url{http://vonjd.github.io/OneR/}
}
\seealso{
\code{\link{bin}}, \code{\link{optbin}}, \code{\link{eval_model}}, \code{\link{maxlevels}}
}
\keyword{1R}
\keyword{One}
\keyword{OneR}
\keyword{Rule}

