% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_image_rscript.R
\name{Augmentation}
\alias{Augmentation}
\title{image augmentations of a matrix, data frame, array or a list of 3-dimensional arrays}
\usage{
Augmentation(image, flip_mode = NULL, crop_width = NULL,
  crop_height = NULL, resiz_width = 0, resiz_height = 0,
  resiz_method = "nearest", shift_rows = 0, shift_cols = 0,
  rotate_angle = 0, rotate_method = "nearest", zca_comps = 0,
  zca_epsilon = 0, image_thresh = 0, padded_value = 0, threads = 1,
  verbose = FALSE)
}
\arguments{
\item{image}{a matrix, data frame, array or list of 3-dimensional arrays}

\item{flip_mode}{a character string ('horizontal', 'vertical')}

\item{crop_width}{an integer specifying the new width of the image, after the image is cropped. Corresponds to the image-rows.}

\item{crop_height}{an integer specifying the new height of the image, after the image is cropped. Corresponds to the image-columns.}

\item{resiz_width}{an integer specifying the new width of the image, after the image is resized. Corresponds to the image-rows.}

\item{resiz_height}{an integer specifying the new height of the image, after the image is resized. Corresponds to the image-columns.}

\item{resiz_method}{a string specifying the interpolation method when resizing an image ('nearest', 'bilinear')}

\item{shift_rows}{a positive or negative integer specifying the direction that the rows should be shifted}

\item{shift_cols}{a positive or negative integer specifying the direction that the columns should be shifted}

\item{rotate_angle}{an integer specifying the rotation angle of the image}

\item{rotate_method}{a string specifying the interpolation method when rotating an image ('nearest', 'bilinear')}

\item{zca_comps}{an integer specifying the number of components to keep by zca whitening, when svd is performed}

\item{zca_epsilon}{a float specifying the regularization parameter by zca whitening}

\item{image_thresh}{the threshold parameter, by image thresholding, should be between 0 and 1 if the data is normalized or between 0-255 otherwise}

\item{padded_value}{either a numeric value or a numeric vector of length equal to N of an N-dimensional array. If it's not equal to 0 then the values of the shifted rows or columns will be filled with the user-defined padded_value. Applies only to the shift_rows and shift_cols parameters.}

\item{threads}{an integer specifying the number of cores to run in parallel ( applies only in case that the image parameter is an array )}

\item{verbose}{a boolean (TRUE, FALSE). If TRUE, then the total time of the preprocessing task will be printed.}
}
\value{
the output is of the same type with the input (in case of a data frame it returns a matrix)
}
\description{
image augmentations of a matrix, data frame, array or a list of 3-dimensional arrays
}
\details{
This function takes advantage of various methods to accomplish image augmentations. The order of the preprocessing steps, in case that all transformations are applied to an image,
is : 1st flip image, 2nd crop image, 3rd resize image, 4th shift rows or columns, 5th rotate image, 6th zca-whitening and 7th image-thresholding.
}
\examples{

# a matrix
object = matrix(1, 10, 10)

res = Augmentation(object, resiz_width = 8, resiz_height = 8, rotate_angle = 40)


# an array
object = array(0, dim = c(10, 10, 3))

res = Augmentation(object, resiz_width = 8, resiz_height = 8, rotate_angle = 30)


# an array (multiple matrices)
object = array(0, dim = c(10, 10, 10))

res = Augmentation(object, resiz_width = 8, resiz_height = 8, rotate_angle = 20)


# a list of 3-dimensional arrays
object = list(array(0, dim = c(10, 10, 3)), array(0, dim = c(10, 10, 3)))                

res = Augmentation(object, resiz_width = 8, resiz_height = 8, rotate_angle = 40)

}
\author{
Lampros Mouselimis
}
