% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_image_rscript.R
\name{uniform_filter}
\alias{uniform_filter}
\title{uniform filter (convolution with uniform kernel)}
\usage{
uniform_filter(image, size, conv_mode = "same")
}
\arguments{
\item{image}{matrix or 3-dimensional array}

\item{size}{a 2-item vector specifying the horizontal and vertical dimensions of the uniform kernel, e.g. c(3,3)}

\item{conv_mode}{the convolution mode should be one of 'same', 'full'}
}
\value{
depending on the input, either a matrix or an array
}
\description{
uniform filter (convolution with uniform kernel)
}
\details{
This function applies a uniform filter to a matrix or to a 3-dimensional array
}
\examples{

path = system.file("tmp_images", "1.png", package = "OpenImageR")

image = readImage(path)

filt = uniform_filter(image, c(4,4), conv_mode = "same")

}
\author{
Lampros Mouselimis
}
