% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertOMLRunToBMR.R
\name{convertOMLRunToBMR}
\alias{convertOMLRunToBMR}
\title{Convert an OpenML run set to a benchmark result for mlr.}
\usage{
convertOMLRunToBMR(run, measures, recompute = FALSE)
}
\arguments{
\item{run}{[\code{\link{OMLRun}}]\cr
The run that should be converted.}

\item{measures}{[\code{character}]\cr
Character describing the measures (see \code{\link{listOMLEvaluationMeasures}})
that will be converted into mlr \code{\link[mlr]{measures}} and are then used in the \code{\link[mlr]{BenchmarkResult}}.
Currently, not all measures from OpenML can be converted into mlr measures.}

\item{recompute}{[\code{logical(1)}]\cr
Should the measures be recomputed with mlr using the predictions? Currently recomputing is not supported.}
}
\value{
[\code{\link[mlr]{BenchmarkResult}}].
}
\description{
Converts an \code{\link{OMLRun}} to a \code{\link[mlr]{BenchmarkResult}}.
}
\seealso{
Other run-related functions: \code{\link{convertOMLMlrRunToBMR}},
  \code{\link{deleteOMLObject}}, \code{\link{getOMLRun}},
  \code{\link{listOMLRuns}},
  \code{\link{makeOMLRunParameter}},
  \code{\link{makeOMLRun}}, \code{\link{tagOMLObject}},
  \code{\link{uploadOMLRun}}
}
