/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class OsmTileLoader
implements TileLoader {
    public static String USER_AGENT = null;
    public static String ACCEPT = "text/html, image/png, image/jpeg, image/gif, */*";
    protected TileLoaderListener listener;

    public OsmTileLoader(TileLoaderListener listener) {
        this.listener = listener;
    }

    public Runnable createTileLoaderJob(final TileSource source, final int tilex, final int tiley, final int zoom) {
        return new Runnable(){
            InputStream input = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Tile tile;
                TileCache cache;
                TileCache tileCache = cache = OsmTileLoader.this.listener.getTileCache();
                synchronized (tileCache) {
                    tile = cache.getTile(source, tilex, tiley, zoom);
                    if (tile == null || tile.isLoaded() || tile.loading) {
                        return;
                    }
                    tile.loading = true;
                }
                try {
                    try {
                        URLConnection conn = OsmTileLoader.this.loadTileFromOsm(tile);
                        OsmTileLoader.this.loadTileMetadata(tile, conn);
                        if ("no-tile".equals(tile.getValue("tile-info"))) {
                            tile.setError("No tile at this zoom level");
                        } else {
                            this.input = conn.getInputStream();
                            tile.loadImage(this.input);
                            this.input.close();
                            this.input = null;
                        }
                        tile.setLoaded(true);
                        OsmTileLoader.this.listener.tileLoadingFinished(tile, true);
                    }
                    catch (Exception e) {
                        tile.setError(e.getMessage());
                        OsmTileLoader.this.listener.tileLoadingFinished(tile, false);
                        if (this.input == null) {
                            System.err.println("failed loading " + zoom + "/" + tilex + "/" + tiley + " " + e.getMessage());
                        }
                        tile.loading = false;
                        tile.setLoaded(true);
                    }
                }
                finally {
                    tile.loading = false;
                    tile.setLoaded(true);
                }
            }
        };
    }

    protected URLConnection loadTileFromOsm(Tile tile) throws IOException {
        URL url = new URL(tile.getUrl());
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof HttpURLConnection) {
            this.prepareHttpUrlConnection((HttpURLConnection)urlConn);
        }
        urlConn.setReadTimeout(30000);
        return urlConn;
    }

    protected void loadTileMetadata(Tile tile, URLConnection urlConn) {
        String str = urlConn.getHeaderField("X-VE-TILEMETA-CaptureDatesRange");
        if (str != null) {
            tile.putValue("capture-date", str);
        }
        if ((str = urlConn.getHeaderField("X-VE-Tile-Info")) != null) {
            tile.putValue("tile-info", str);
        }
    }

    protected void prepareHttpUrlConnection(HttpURLConnection urlConn) {
        if (USER_AGENT != null) {
            urlConn.setRequestProperty("User-agent", USER_AGENT);
        }
        urlConn.setRequestProperty("Accept", ACCEPT);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

