% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_obwoe.R
\name{step_obwoe_new}
\alias{step_obwoe_new}
\title{Internal Constructor for step_obwoe}
\usage{
step_obwoe_new(
  terms,
  role,
  trained,
  outcome,
  algorithm,
  min_bins,
  max_bins,
  bin_cutoff,
  output,
  suffix_woe,
  suffix_bin,
  na_woe,
  control,
  binning_results,
  skip,
  id
)
}
\arguments{
\item{terms}{A list of quosures specifying the variables to transform.}

\item{role}{For variables created by this step, what role should they have?

  Default is \code{"predictor"}.}

\item{trained}{A logical indicating whether the step has been trained
(fitted). This should not be set manually.}

\item{outcome}{A character string specifying the name of the binary or
multinomial response variable. This argument is \strong{required} as all
binning algorithms are supervised. The outcome must exist in the training
data provided to \code{prep()}. The outcome should be encoded as a factor
(standard for tidymodels classification) or as integers 0/1 for binary,
0/1/2/... for multinomial.}

\item{algorithm}{Character string specifying the binning algorithm to use.
  Use \code{"auto"} (default) for automatic selection based on target type:
  \code{"jedi"} for binary targets, \code{"jedi_mwoe"} for multinomial.

  Available algorithms are organized by supported feature types:

  \strong{Universal (numerical and categorical):}
  \code{"auto"}, \code{"jedi"}, \code{"jedi_mwoe"}, \code{"cm"}, \code{"dp"},
  \code{"dmiv"}, \code{"fetb"}, \code{"mob"}, \code{"sketch"}, \code{"udt"}

  \strong{Numerical only:}
  \code{"bb"}, \code{"ewb"}, \code{"fast_mdlp"}, \code{"ir"}, \code{"kmb"},
  \code{"ldb"}, \code{"lpdb"}, \code{"mblp"}, \code{"mdlp"}, \code{"mrblp"},
  \code{"oslp"}, \code{"ubsd"}

  \strong{Categorical only:}
  \code{"gmb"}, \code{"ivb"}, \code{"mba"}, \code{"milp"}, \code{"sab"},
  \code{"sblp"}, \code{"swb"}

  This parameter is tunable with \code{tune()}.}

\item{min_bins}{Integer specifying the minimum number of bins to create.
Must be at least 2. Default is 2. This parameter is tunable with
\code{tune()}.}

\item{max_bins}{Integer specifying the maximum number of bins to create.
Must be greater than or equal to \code{min_bins}. Default is 10. This
parameter is tunable with \code{tune()}.}

\item{bin_cutoff}{Numeric value between 0 and 1 (exclusive) specifying the
minimum proportion of total observations that each bin must contain. Bins
with fewer observations are merged with adjacent bins. This serves as a
regularization mechanism to prevent overfitting and ensure statistical
stability of WoE estimates. Default is 0.05 (5\%). This parameter is
tunable with \code{tune()}.}

\item{output}{Character string specifying the transformation output format:
\describe{
  \item{\code{"woe"}}{Replaces the original variable with WoE values
    (default). This is the standard choice for logistic regression
    scorecards.
  }
  \item{\code{"bin"}}{Replaces the original variable with bin labels
    (character). Useful for tree-based models or exploratory analysis.
  }
  \item{\code{"both"}}{Keeps the original column and adds two new columns
    with suffixes \code{_woe} and \code{_bin}. Useful for model comparison
    or audit trails.
  }
}}

\item{suffix_woe}{Character string suffix appended to create WoE column names
when \code{output = "both"}. Default is \code{"_woe"}.}

\item{suffix_bin}{Character string suffix appended to create bin column names
when \code{output = "both"}. Default is \code{"_bin"}.}

\item{na_woe}{Numeric value to assign to observations that cannot be mapped
to a bin during \code{bake()}. This includes missing values (\code{NA}) and
unseen categories not present in the training data. Default is 0, which
represents neutral evidence (neither good nor bad).}

\item{control}{A named list of additional control parameters passed to
\code{\link{control.obwoe}}. These provide fine-grained control over
algorithm behavior such as convergence thresholds and maximum pre-bins.
Parameters specified directly in \code{step_obwoe()} (e.g.,
\code{bin_cutoff}) take precedence over values in this list.}

\item{binning_results}{Internal storage for fitted binning models after
\code{prep()}. Do not set manually.}

\item{skip}{Logical. Should this step be skipped when \code{bake()} is
called on new data? Default is \code{FALSE}. Setting to \code{TRUE} is
rarely needed for WoE transformations but may be useful in specialized
workflows.}

\item{id}{A unique character string to identify this step. If not provided,
a random identifier is generated.}
}
\value{
A step_obwoe object.
}
\description{
Creates a new step_obwoe object. This is an internal function and should
not be called directly by users.
}
\keyword{internal}
