% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsortedFactor.R
\name{unsortedFactor}
\alias{unsortedFactor}
\title{Factor with unsorted levels}
\usage{
unsortedFactor(x, ...)
}
\arguments{
\item{x}{A \code{character} vector with elements to converted to 
\code{factor}.}

\item{...}{Additional arguments passed to \code{\link{factor}}.}
}
\description{
Casting \code{\link{factor}} upon a (\code{character}) vector usually results 
in alphabetically ordered factor levels. Although this seems reasonable in 
most cases, the automated ordering of factor levels is seldomly desirable in 
the context of visualization, e.g. when working with tiled \strong{lattice} 
or \strong{ggplot2} figures. This function returns a \code{factor} with 
levels ordered according to their first appearance in the supplied vector.
}
\examples{
mnth <- month.abb

## factor levels are being sorted
fc_mnth <- factor(mnth)
levels(fc_mnth)

## factor levels remain unsorted
fc_mnth2 <- unsortedFactor(mnth)
levels(fc_mnth2)

}
\seealso{
\code{\link{factor}}
}
\author{
Florian Detsch
}
