% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_v2.R
\name{OCD}
\alias{OCD}
\title{Causal Discovery for Ordinal Categorical Data}
\usage{
OCD(y, search = "greedy", ic = "bic", link = "probit", G = NULL, nstart = 1)
}
\arguments{
\item{y}{a data frame with each column being an ordinal categorical variable, which must be a factor.}

\item{search}{the search method used to find the best-scored DAG. The default search method is "greedy". When the number of nodes is less than 4, "exhaust" search is available.}

\item{ic}{the information criterion (AIC or BIC) used to score DAGs. The default is "bic".}

\item{link}{the link function for ordinal regression. The default is "probit". Other choices are "logistic", "loglog", "cloglog", and "cauchit".}

\item{G}{a list of DAG adjacency matrices that users want to restrict their search on for the "exhaust" search. The default is "NULL" meaning no restriction imposed on the search.}

\item{nstart}{number of random graph initializations for the "greedy" search.}
}
\value{
A list with two elements, gam and ic_best. gam is an estimated DAG adjacency matrix whose (i,j)th entry is 1 if j->i is present in the graph and 0 otherwise. ic_best is the correponding information criterion value.
}
\description{
Estimate a causal directed acyclic graph (DAG) for ordinal categorical data with greedy or exhaustive search.
}
\examples{
set.seed(2020)
n=1000 #sample size
q=5 #number of nodes
y = u = matrix(0,n,q)
u[,1] = 4*rnorm(n)
y[,1] = (u[,1]>1) + (u[,1]>2)
for (j in 2:q){
  u[,j] = 2*y[,j-1] + rnorm(n)
  y[,j]=(u[,j]>1) + (u[,j]>2)
}
A=matrix(0,q,q) #true DAG adjacency matrix
A[2,1]=A[3,2]=A[4,3]=A[5,4]=1
y=as.data.frame(y)
for (j in 1:q){
  y[,j]=as.factor(y[,j])
}

G=OCD(y) #estimated DAG adjacency matrix
print(A)
print(G)
}
