% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dml_with_smoother.R
\name{dml_with_smoother}
\alias{dml_with_smoother}
\title{Double ML estimators with outcome smoothers}
\usage{
dml_with_smoother(
  Y,
  D,
  X,
  Z = NULL,
  estimators = c("PLR", "PLR_IV", "AIPW_ATE", "Wald_AIPW"),
  smoother = "honest_forest",
  n_cf_folds = 5,
  n_reps = 1,
  ...
)
}
\arguments{
\item{Y}{Numeric vector containing the outcome variable.}

\item{D}{Optional binary treatment variable.}

\item{X}{Covariate matrix with N rows and p columns.}

\item{Z}{Optional binary instrumental variable.}

\item{estimators}{String (vector) indicating which estimators should be run.
Current menu: c("PLR","PLR_IV","AIPW_ATE","Wald_AIPW")}

\item{smoother}{Indicate which smoother to be used for nuisance parameter estimation.
Currently only available option \code{"honest_forest"} from the \pkg{grf} package.}

\item{n_cf_folds}{Number of cross-fitting folds. Default is 5.}

\item{n_reps}{Number of repetitions of cross-fitting. Default is 1.}

\item{...}{Options to be passed to smoothers.}
}
\value{
A list with three entries:
\itemize{
\item \code{results}: a list storing the results, influence functions, and score functions of each estimator
\item \code{NuPa.hat}: a list storing the estimated nuisance parameters and the outcome smoother matrices
}
}
\description{
Existing Double ML implementations are too general to easily extract smoother matrices
required to be compatible with the get_forest_weights() method. This motivates yet
another Double ML implementation.
}
\examples{
\donttest{
# Sample from DGP borrowed from grf documentation
n = 200
p = 5
X = matrix(rbinom(n * p, 1, 0.5), n, p)
Z = rbinom(n, 1, 0.5)
Q = rbinom(n, 1, 0.5)
W = Q * Z
tau =  X[, 1] / 2
Y = rowSums(X[, 1:3]) + tau * W + Q + rnorm(n)

# Run outcome regression and extract smoother matrix
# Run DML and look at results
dml = dml_with_smoother(Y,W,X,Z)
results_dml = summary(dml)
plot(dml)

# Get weights
omega_dml = get_outcome_weights(dml)

# Observe that they perfectly replicate the original estimates
all.equal(as.numeric(omega_dml$omega \%*\% Y), 
          as.numeric(as.numeric(results_dml[,1])))

# The weights can then be passed to the cobalt package for example.
}

}
\references{
Chernozhukov, V., Chetverikov, D., Demirer, M., Duflo, E., Hansen, C., Newey, W., & Robins, J. (2018).
Double/debiased machine learning for treatment and structural parameters. The Econometrics Journal, 21(1), C1-C68.

Knaus, M. C. (2024). Treatment effect estimators as weighted outcomes, \url{https://arxiv.org/abs/2411.11559}.
}
