% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grf.R
\name{get_outcome_weights.instrumental_forest}
\alias{get_outcome_weights.instrumental_forest}
\title{Outcome weights for the \code{\link[grf]{instrumental_forest}} function}
\usage{
\method{get_outcome_weights}{instrumental_forest}(object, ..., S, newdata = NULL, checks = TRUE)
}
\arguments{
\item{object}{An object of class \code{instrumental_forest}, i.e. the result of running \code{\link[grf]{instrumental_forest}}.}

\item{...}{Pass potentially generic \link{get_outcome_weights} options.}

\item{S}{A smoother matrix reproducing the outcome predictions used in building the \code{\link[grf]{instrumental_forest}}.
Obtained by calling \code{get_forest_weights()} for the \code{\link[grf]{regression_forest}} object producing the outcome predictions.}

\item{newdata}{Corresponds to \code{newdata} option in \code{\link[grf]{predict.instrumental_forest}}. If \code{NULL},
out-of-bag outcome weights, otherwise for those for the provided test data returned.}

\item{checks}{Default \code{TRUE} checks whether weights numerically replicate original estimates. Only set \code{FALSE} if you
know what you are doing and want to save computation time.}
}
\value{
\link{get_outcome_weights} object with \code{omega} containing weights and \code{treat} the treatment
}
\description{
Post-estimation command to extract outcome weights for instrumental forest
implemented via the \code{\link[grf]{instrumental_forest}} function from the \pkg{grf} package.
}
\examples{
\donttest{
# Sample from DGP borrowed from grf documentation
n = 2000
p = 5
X = matrix(rbinom(n * p, 1, 0.5), n, p)
Z = rbinom(n, 1, 0.5)
Q = rbinom(n, 1, 0.5)
W = Q * Z
tau =  X[, 1] / 2
Y = rowSums(X[, 1:3]) + tau * W + Q + rnorm(n)

# Run outcome regression and extract smoother matrix
forest.Y = grf::regression_forest(X, Y)
Y.hat = predict(forest.Y)$predictions
outcome_smoother = grf::get_forest_weights(forest.Y)

# Run instrumental forest with external Y.hats
iv.forest = grf::instrumental_forest(X, Y, W, Z, Y.hat = Y.hat)

# Predict on out-of-bag training samples.
iv.pred = predict(iv.forest)$predictions

omega_if = get_outcome_weights(iv.forest, S = outcome_smoother)

# Observe that they perfectly replicate the original CLATEs
all.equal(as.numeric(omega_if$omega \%*\% Y), 
          as.numeric(iv.pred))

}

}
\references{
Athey, S., Tibshirani, J., & Wager, S. (2019). Generalized random forest. The Annals of Statistics, 47(2), 1148-1178.

Knaus, M. C. (2024). Treatment effect estimators as weighted outcomes, \url{https://arxiv.org/abs/2411.11559}.
}
